

with `full_dt` as (
     SELECT 
            json_extract(payload, "$.pull_request.base.repo.id") head_repo_id , 
            json_extract(payload, "$.pull_request.base.repo.full_name") head_repo_full_name , 
            json_extract(payload, "$.pull_request.base.repo.name") head_repo_name , 
            json_extract(payload, "$.pull_request.base.repo.created_at") created_at , 
            json_extract(payload, "$.pull_request.base.repo.updated_at") updated_at , 
            json_extract(payload, "$.pull_request.base.repo.private") private , 
            json_extract(payload, "$.pull_request.base.repo.stargazers_count") stargazers_count , 
            json_extract(payload, "$.pull_request.base.repo.watchers_count") watchers_count , 
            replace(json_extract(payload, "$.pull_request.base.repo.language"),'"','')  repo_language , 
            json_extract(payload, "$.pull_request.base.repo.archived") archived , 
            json_extract(payload, "$.pull_request.base.repo.disabled") disabled , 
            replace(json_extract(payload, "$.pull_request.base.repo.license.key"),'"','')  license , 
            json_extract(payload, "$.pull_request.base.repo.default_branch") default_branch , 
            FROM `githubarchive.day.2017*`  
            WHERE type="PullRequestEvent"   
        and cast(public as bool)=true 
        and cast ( json_extract(payload, "$.pull_request.base.repo.fork") as bool)=false 
        and (json_extract(payload, "$.pull_request.base.repo.license.key") is null or  REGEXP_CONTAINS( lower( json_extract(payload, "$.pull_request.base.repo.license.key") ) , r'mit|artistic|isc|cc|epl|mpl|unlicense|apache|bsd|agpl|lgpl|bsd' )  )
        and  lower( replace(json_extract(payload, "$.pull_request.base.repo.language"),'"','')  ) in ( 'c','c++','objective-c++' , 'objective-c', 'c#' )
        )
  SELECT AS VALUE ARRAY_AGG(t ORDER BY `updated_at` DESC LIMIT 1)[OFFSET(0)]
  from `full_dt` t
  group by head_repo_id
  



