

with `full_dt` as (
     SELECT 
            json_extract(payload, "$.pull_request.head.repo.id") head_repo_id , 
            json_extract(payload, "$.pull_request.head.repo.full_name") head_repo_full_name , 
            json_extract(payload, "$.pull_request.head.repo.name") head_repo_name , 
            json_extract(payload, "$.pull_request.head.repo.created_at") created_at , 
            json_extract(payload, "$.pull_request.head.repo.updated_at") updated_at , 
            json_extract(payload, "$.pull_request.head.repo.private") private , 
            json_extract(payload, "$.pull_request.head.repo.stargazers_count") stargazers_count , 
            json_extract(payload, "$.pull_request.head.repo.watchers_count") watchers_count , 
            replace(json_extract(payload, "$.pull_request.head.repo.language"),'"','')  repo_language , 
            json_extract(payload, "$.pull_request.head.repo.archived") archived , 
            json_extract(payload, "$.pull_request.head.repo.disabled") disabled , 
            replace(json_extract(payload, "$.pull_request.head.repo.license.key"),'"','')  license , 
            json_extract(payload, "$.pull_request.head.repo.default_branch") default_branch , 
            FROM `githubarchive.day.20*`  
            WHERE type="PullRequestEvent"   
        and lower( replace(json_extract(payload, "$.pull_request.head.repo.license.key"),'"','') )  IN ('mit', 'artistic-2.0','isc','cc0-1.0','epl-1.0','mpl-2.0','unlicense','apache-2.0','bsd-3-clause','agpl-3.0','lgpl-2.1','bsd-2-clause' )
        and  lower( replace(json_extract(payload, "$.pull_request.head.repo.language"),'"','')  ) in ( 'c','c++','objective-c++' , 'objective-c', 'c#' )
        )
  SELECT AS VALUE ARRAY_AGG(t ORDER BY `updated_at` DESC LIMIT 1)[OFFSET(0)]
  from `full_dt` t
  group by head_repo_id
  



