import os 

cur_dir =  os.path.dirname(__file__)

from preprocessing import clean_utils 

from unittest import  TestCase

from pprint import pprint 

import io 

import json 

class test_clean(TestCase):
    def setUp(self)->None:
        TestCase.setUp(self)
    def tearDown(self)->None:
        TestCase.tearDown(self)
        
    # def test_extract_code_from_markdown_v2(self):
    #     p1 = os.path.join( cur_dir , "data/pytest-codeblocks_examples.md")
    #     with open(p1) as f :
    #         ret = clean_utils.extract_code_from_markdown_v2(markdown=f.read() )
    #     assert len(ret)>9 
    #
    #
    #     json_p = os.path.join( cur_dir , "data/openai_rsp.json")
    #     with open(json_p ) as f_mock :
    #         ret2 = clean_utils.extract_code_from_markdown_v2(markdown=f_mock .read() )
    #
    #         # print (ret2,"...")
    #         # assert  len(ret2)>0 
    #
    #         f_mock.seek(0)
    #         data= json.load(f_mock)
    #         content = data[-1]["content"]
    #
    #         ret2 = clean_utils.extract_code_from_markdown_v2(markdown=content )
    #         assert  len(ret2)>0
    #
    #     json_p = os.path.join( cur_dir , "data/text-code_APPS003_test.jsonl")
    #     with open(json_p ) as f_mock :
    #         ret2 = clean_utils.extract_code_from_markdown_v2(markdown=f_mock .read() )
    #
    #         # print (ret2,"...")
    #         # assert  len(ret2)>0 
    #
    #         f_mock.seek(0)
    #         for line in f_mock.readlines() :
    #             data= json.loads(line)
    #             content = data["chatgpt_answer"]
    #             print (content , "cotnent")
    #             ret2 = clean_utils.extract_code_from_markdown_v2(markdown=content )
    #             assert  len(ret2)>0


    def test_extract_code_from_markdown(self):
        p1 = os.path.join( cur_dir , "data/pytest-codeblocks_examples.md")
        with open(p1) as f :
            ret = clean_utils.extract_code_from_markdown(markdown=f.read() )
    
        assert len(ret)>9 
    
        json_p = os.path.join( cur_dir , "data/openai_rsp.json")
        with open(json_p ) as f_mock :
            data= json.load(f_mock)
            f_mock.seek(0 )
            ret2 = clean_utils.extract_code_from_markdown(markdown=f_mock .read() )
            assert  len(ret2)>0 
            content = data[-1]["content"]
    
            ret2 = clean_utils.extract_code_from_markdown(markdown=content )
            assert  len(ret2)>0 


    def test_extract2(self):
        
        content_illeges=["""
        ```python
        c
        ```
        """,
        """
        ```
        c
        """,
        """
```python
c
""",
"""
```
c
```
lalal la lalalla l
```
c
```
"""]
        for cx in content_illeges:
            code_out  = clean_utils.extract_code_from_markdown_v2(cx )
            code_out = "\n".join(code_out).strip()
            assert code_out.strip()=="c" or  code_out.strip()=="c\n\nc"  ,code_out
            # print (code_out )
            
        
        content_no_close = """
-1Here is the generated code for the problem description provided:
```
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        return "-1"
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
"""

        content_close = """
0Here is the generated code for the problem description provided:
```
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        return "-1"
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
```
"""
   
        content_close_tag = """
1Here is the generated code for the problem description provided:
```python
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        return "-1"
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
```
"""

   
        content_no_close_tag = """
2Here is the generated code for the problem description provided:
```python
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        return "-1"
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
"""
  
   
        content_illege = """
3Here is the generated code for the problem description provided:
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        return "-1"
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
"""
        content_multi = """
4Here is the generated code for the problem description provided:
```
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        return "-1"
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
```

5Here is the generated code for the problem description provided:
```
def assign_seats1(n: int, a: int, b: int) -> str:
    if a * b < n1:
        return "-11"
    else:1
        se1ating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for1 i in range(n):
            1row = i  
            c1ol = i % b
            pa1rty = "D" if i % 2 == 0 else "R"
            for1 dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            
```
"""

        code_out  = clean_utils.extract_code_from_markdown_v2(content_illege )
        code_out = "\n".join(code_out) 
        
        assert "description" not in  code_out ,  (content_illege, code_out,)
        for content in [content_no_close,content_close,content_close_tag,content_no_close_tag,content_multi ] :
        # for content in [content6 ] : 
            
            code = clean_utils.extract_code_from_markdown_v2(content )
            assert code is not None , content
            if type(code)!=str: code ="\n".join(code)
            
            assert  "def " in code.split("\n")[0] ,code 
            code =code.strip()
            assert "%" in code[-1],code 

    def test_remove_pattern_assert(self):
        content = []

        content += ["""
Here is the generated code for the problem description provided:
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        assert 1==2 
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            assert 1==1, ("1" , \
            "b","newline") 

            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, s)]:
                print (dr)                                                                                            

assert assign_seats(1,2,3)==11
assert assign_seats(11,21,31)==11

"""        ]
        

        content += ["""
Here is the generated code for the problem description provided:
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        assert 1==2 
    else:
        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, %                                                                                            

assert assign_seats(1,2,3)==11
assert assign_seats(11,21,31)==11

"""        ]
        

        content += ["""
        This is a sample text.
        assert some_condition()  # This line should be removed.
        Another line with assert.
        Not an a ssert line.
        """]

        import re
        
        # Print the result
        for input_text in content :
            output_text = re.sub(r'^\s*assert\s+.*$', '', input_text, flags=re.MULTILINE|re.IGNORECASE )
            # print(output_text)
            assert "assert " not in output_text


        # code = clean_utils.remove_pattern_assert(content )
        # assert code.count("assert")==1 
        
        
    def test_remove_pattern_print(self):
        
        content = """
def assign_seats(n: int, a: int, b: int) -> str:
    print ("123")

    if a * b < n:
        assert 1==2 
    else:
        print ("123")

        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, 1)]:
                sss=1
    print ("123")
assert assign_seats(1,2,3)==11
assert assign_seats(11,21,31)==11
"""        

        code = clean_utils.remove_pattern_print(content )
        print (code )
        assert code.count("print (")==0
        
        
        content = """
def assign_seats(n: int, a: int, b: int) -> str:
    if a * b < n:
        assert 1==2 

        seating_arrangement = [[0 for j in range(b)] for i in range(a)]
        for i in range(n):
            row = i  
            col = i % b
            party = "D" if i % 2 == 0 else "R"
            for dr, dc in [(0, 1), (0, -1), (1, 0), (-1, 1)]:
                sss=1
assert assign_seats(1,2,3)==11
assert assign_seats(11,21,31)==11
"""        

        code = clean_utils.remove_pattern_print(content )
        print (code )
        assert code.count("print (")==0
        
        