



test_code = """
x = 10
y = 20

class CCCyclass:
    def __init__(self):
        pass
    def member_func(self):
        def member_func_sub1():
            def member_func_sub12():
                passs
            x = member_func_sub12()
            return vars
        obj = member_func_sub1()
        return obj

def visit(p1,p2):
    p1=1
    p2=1
    return visit(p2,p1)

def my_function_parent():

    def my_function():
        z = 30

class MyClass:
    class_var = 100

    def __init__(self):
        self.instance_var = 50

    def class_method(self):
        class_var = 200
        local_var = 300

def my_function():
    z = 30
    x = 5
"""


#
#
import ast 
import astor 
import random 
random.seed(0)
from mutations.funcs.rename import mt_rename, mt_func_rename

import unittest
import difflib
from termcolor import colored

'''
pytest --randomly-seed=1234  -vv  -s  tests/mutations/test_rename.py 

python -m pip install pytest-randomly

'''
from unittest.mock import patch

class run(unittest.TestCase):

    # @patch('random.seed')
    def test_rename_var(self):
    
        with patch('random.seed', return_value=3) as mock_random:
    
            ret_code = mt_rename(python_code = test_code, rename_candidates={"p1":"p1_new","p2":"p2_new"} )
            # print (ret_code)
            assert "p1=" in test_code and "p2="  in test_code , ret_code
            assert "p1=" not in ret_code and "p2="  not in ret_code , ret_code
            assert "p1_new" in ret_code and "p2_new"  in ret_code , ret_code
    
    
            renamed_code =  mt_rename( python_code = test_code, rename_candidates=None, rate=0.8  )
            # print (renamed_code)
            diff = "".join(difflib.unified_diff(test_code.splitlines(1), renamed_code.splitlines(1)))
            diff_lines = [ l.startswith('+') or l.startswith('-') for l in diff.splitlines() ]
            
            assert  sum(diff_lines)> 4
             

            for l in diff.splitlines():
                if l.startswith('+'):
                    print(colored(l, 'green'))
                elif l.startswith('-'):
                    print(colored(l, 'red'))
                else:
                    print(l)
                    
    #
    def test_rename_func(self):
    
        with patch('random.seed', return_value=3) as mock_random:
    
            ret_code = mt_rename(python_code = test_code, rename_candidates={"visit":"visit_new"} )
            # print (ret_code)
            assert "visit_new(" in ret_code and "visit(" not in ret_code , ret_code
    
    
            renamed_code =  mt_rename( python_code = test_code, rename_candidates=None, rate=0.8  )
            print (renamed_code)
            diff = "".join(difflib.unified_diff(test_code.splitlines(1), renamed_code.splitlines(1)))
            diff_lines = [ l.startswith('+') or l.startswith('-') for l in diff.splitlines() ]
    
            assert  sum(diff_lines)> 4
    
    
            for l in diff.splitlines():
                if l.startswith('+'):
                    print(colored(l, 'green'))
                elif l.startswith('-'):
                    print(colored(l, 'red'))
                else:
                    print(l)



