
import ast 
import astor 
#
import difflib
from  unittest import TestCase 

from mutations import processor as mt_processor  

from mutations.funcs.deadcode import  add_deadcode


import random 

class MtCalss (TestCase):

    def setUp(self)->None:
        TestCase.setUp(self)


    def tearDown(self)->None:
        TestCase.tearDown(self)


    def test_mt_rename(self):

        random.seed(10)

        code = """

def rename123(xxxx,yyyy):
    print ("123")
    xxxx="1"
    yyyy="1"
"""

        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= [] )
        code_mt = self.transformer( code= code )
        assert "rename123"  in code_mt and "xxxx"   in code_mt  and "yyyy"  in code_mt  , code_mt 


        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["rename_func"] )
        code_mt = self.transformer( code= code )


        assert "rename123"  not in code_mt , code_mt 


        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["rename_var"] )
        code_mt = self.transformer( code= code  )


        assert "rename123"  in code_mt  ,code_mt 
        assert "xxxx" not  in code_mt  and "yyyy" not in code_mt  , code_mt 

        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["rename_var","rename_func"] )
        code_mt = self.transformer(code= code  )


        assert "rename123"  not in code_mt  ,code_mt 
        assert "xxxx"  not in code_mt  and "yyyy" not in code_mt  , code_mt 



    def test_mt_expr(self):

        random.seed(10)

        code = """
def rename123(xxxx,yyyy):
    print ("123")
    xxxx="1"
    xxxx= hasattr(yyyy,"__name__")
    this_IfExp = "a" if xxxx=="c" else "b"
    if xxxx=="2":
        yyyy="1"
    else:
        yyyy="3"
    xxx_AugAssign += xxxx
    while  yyyy==3:
        xxxx="while"
        
    this_Comp2For_value = [this_Comp2For+1 for this_Comp2For in range(10)]
"""
        MT_OPERATE_EXPR_LIST=[
            "ExprStmt2Assign",
            "IfExpr2Stmt",
            "WhileStmt",
            "IfStmt2IfStmt",
            # "AssginAddLine",
            "AugAssgin2Assign",
            "Comp2For",
            ]



        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["ExprStmt2Assign",] )
        code_mt = self.transformer( code= code  )
        for line in code_mt.split("\n"):
            if "print" in line:
                assert  "=" in line and "print" in line and "(" in line , line 

        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["IfExpr2Stmt",] )
        code_mt = self.transformer( code= code  )
        assert code_mt.count("this_IfExp") ==2 

        
        
        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["WhileStmt",] )
        code_mt = self.transformer( code= code  )
        assert code_mt.count("while True") >=1 
        
        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["IfStmt2IfStmt",] )
        code_mt = self.transformer( code= code  )
        assert code_mt.count("if xxxx !=") >=1 
        
        
        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["AugAssgin2Assign",] )
        code_mt = self.transformer( code= code  )
        assert code_mt.count("xxx_AugAssign = xxx_AugAssign") >=1 

        self.transformer = mt_processor.MutateModel(rate= 1.0,op_names= ["Comp2For",] )
        code_mt = self.transformer( code= code  )
        assert code_mt.count("this_Comp2For_value.append") >=1 




    def test_insert_deadcode(self,name_set=set()):
        import tempfile
        import time 
        import subprocess
        from tqdm import tqdm 
        def call(code_block):
            
            with tempfile.NamedTemporaryFile(mode='w', delete=True, suffix='.py') as temp_file:
                temp_file.write(code_block)
                # time.sleep(1)
    
                temp_script_path = temp_file.name
                command = ["python", temp_script_path]
                process = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                stdout, stderr = process.communicate()
                return_code = process.returncode
            
                return return_code


        code="""
def insert_deadcode_here():
    
    pass
    
    """
        for dead_type in tqdm(range(0,7) ):
            class FunctionInsertionTransformer(ast.NodeTransformer):
                def visit_FunctionDef(self, node, **kwargs):
                    # When a function definition is encountered, insert the custom node before it
                    ast_nodes = add_deadcode(node,dead_type=dead_type  )
                    build_nodes = []
                    ast_nodes = random.sample(ast_nodes,1)
                    [build_nodes.extend(list(l)) for l in ast_nodes ] 
                    new_body =  build_nodes + node.body 
                    # new_body = list( chain(*ast_nodes)) + node.body
                    node.body = new_body
                    return node
        
            tree_node=ast.parse(code)
            transformer = FunctionInsertionTransformer()
            modified_ast = transformer.visit(tree_node)
            
            new_code = astor.to_source( modified_ast )
            
            ret_code = call(new_code )
            assert ret_code==0 ,(ret_code ,new_code)
      
      