
import yaml 
from glob2 import glob 
import os 

from tqdm import tqdm 


for registry_path in ["../registry_dir"]:
    #registry_path = "../registry_dir_train"

    os.makedirs(registry_path,exist_ok=True)
    os.makedirs(os.path.join(registry_path,"evals"),exist_ok=True)
    os.makedirs(os.path.join(registry_path,"data"),exist_ok=True)
    os.makedirs(os.path.join(registry_path,"completion_fns"),exist_ok=True)


    scan_dir =  os.path.join(registry_path,"data")#"../registry_dir"


    fl=[]
    fl += glob( os.path.join(scan_dir, "*.jsonl")) 

    #fl = glob( os.path.join(scan_dir, "*val*.jsonl")) 
    #fl+= glob( os.path.join(scan_dir, "*train*.jsonl")) 


    for path in tqdm(fl ) :
        registry_yaml = {}
        path_base = os.path.basename(path)
        

        registry_yaml[path_base] = {
            "id": path_base+":test", 
            "metrics": ["accuracy"]
        }
        registry_yaml[path_base+":test"] = {
            "class": "evals.elsuite.basic.includes:Includes",
            "args": {
                "samples_jsonl": os.path.abspath(path) ,
        #        "temperature": 0.8 ,
        #        "top_p": 0.95 ,
                "max_tokens": 2048 ,
            }
        }
        
        with open(os.path.join(registry_path, "evals", f"{path_base}.yaml"), "w") as f:
            yaml.dump(registry_yaml, f)
