import json 


template_system=lambda lang:{
    "role":"system",
    "content":"Please complete the python code generation for the following "\
        "question, there may have some example test cases, and "\
        "you can use them to evaluate the generated code. "\
        "Do not provide any explanations, comments, test cases or "\
        "additional text, only output the completed python code in "\
        "a markdown style and nothing else.",
    "name":"system",
    }

template_user_testcase= lambda item :item["text"]+"\n\nThe testcases: "+"\n".join(item["test_list"][:20])

template_user=lambda item:{
    "role":"user",
    "content":template_user_testcase(item) , 
    "name":"user",
    }



def build_zeroshot(lang,task_id,item  ):
    
    ret = {
        "input":[
            template_system(lang),
            template_user(item)
            ],
        "task_id":task_id,
        "human_answer":item["code"],
        "idx":task_id,
        "ideal":item["code"],
        "sql_id":f"text-code/{task_id}",
        }
    return ret 
    
# from datasets import load_dataset
# dataset = load_dataset("codeparrot/apps")

DATA_URL ="https://raw.githubusercontent.com/google-research/google-research/master/mbpp/mbpp.jsonl"
import requests 
import json 
con = requests.get(DATA_URL) .content 
con = con. decode("utf-8")

dt_test = [ json.loads(line)   for idx, line in enumerate( con.split("\n")  )  if len(line)>0 ]
        



for str_role in ["train"]:
    # dt_test = dataset[ str_role ]
    
    app_list = []
    for  idx,item in enumerate(dt_test):
        # print (list(item), "list.item")
        item_str = build_zeroshot(lang="python", item=item, task_id ="MBPP_001/{}/{}.input".format(str_role , idx) )
        app_list.append ( json.dumps(item_str ) )
    
    
    with open ("/data3/icse_dataset/raw_data/mbpp_{}.jsonl".format(str_role) ,"w") as f :
        f.write("\n".join(app_list)) 
        
    with open ("/data3/icse_dataset/wj_build_prompt_data/mbpp_{}.jsonl".format(str_role) ,"w") as f :
        f.write("\n".join(app_list)) 
        
