import json 


template_system=lambda lang:{
    "role":"system",
    "content":"Please complete the python code generation for the following "\
        "question, there may have some example test cases, and "\
        "you can use them to evaluate the generated code. "\
        "Do not provide any explanations, comments, test cases or "\
        "additional text, only output the completed python code in "\
        "a markdown style and nothing else.",
    "name":"system",
    }


template_user=lambda content:{
    "role":"user",
    "content":content , 
    "name":"user",
    }


import json 
def choice_answer(solutions ):
    '''
    return first element
    '''
    if len(solutions)<=0 :
        return None 
    solutions = json.loads(solutions)
    if len(solutions)<=0:
        return None 
    
    return solutions[0]


def build_zeroshot(lang,user_content,task_id ,item_misc={}, index_id=0, role="train" ):
    
    ret = {
        # **item_misc,
        # "input":[
        #     template_system(lang),
        #     template_user(user_content)
        #     ],
        "task_id":task_id,
        # "idx":task_id,
        "human_answer": choice_answer(solutions= item_misc["solutions"] ) ,
        "sql_id":f"text-code/APPS_001/{role}/{index_id}.input"
        }
    return ret 
    
from datasets import load_dataset
dataset = load_dataset("codeparrot/apps")


for str_role in ["test","train"]:
    dt_test = dataset[ str_role ]
    
    app_list = []
    for  idx,item in enumerate(dt_test):
        item_str = build_zeroshot(lang="python", user_content=item["question"], task_id ="apps_{}_{}".format(str_role , idx) , item_misc=item ,index_id=idx,role=str_role )
        app_list.append ( json.dumps(item_str ) )
    
    
    with open ("/data3/icse_dataset/wj_build_prompt_data/apps_{}.jsonl".format(str_role) ,"w") as f :
        f.write("\n".join(app_list)) 
        
