import json 


template_system=lambda lang:{
    "role":"system",
    "content":"Please complete the python code generation for the following "\
        "question, there may have some example test cases, and "\
        "you can use them to evaluate the generated code. "\
        "Do not provide any explanations, comments, test cases or "\
        "additional text, only output the completed python code in "\
        "a markdown style and nothing else.",
    "name":"system",
    }


template_user=lambda content:{
    "role":"user",
    "content":content , 
    "name":"user",
    }



def build_zeroshot(lang,user_content,task_id ):
    
    ret = {
        "input":[
            template_system(lang),
            template_user(user_content)
            ],
        "task_id":task_id,
        "idx":task_id,
        "ideal":"",
        }
    return ret 
    
from datasets import load_dataset
dataset = load_dataset("codeparrot/apps")


for str_role in ["test","train"]:
    dt_test = dataset[ str_role ]
    
    app_list = []
    for  idx,item in enumerate(dt_test):
        item_str = build_zeroshot(lang="python", user_content=item["question"], task_id ="apps_{}_{}".format(str_role , idx) )
        app_list.append ( json.dumps(item_str ) )
    
    
    with open ("/data3/icse_dataset/raw_data/apps_{}.jsonl".format(str_role) ,"w") as f :
        f.write("\n".join(app_list)) 
        
