import ast 

from .funcs._controller import ExprProcessor

from .funcs.rename import mt_rename 
from .funcs.rename import mt_func_rename

from .funcs.deadcode import mt_deadcode

 



MT_OPERATE_RENAME_LIST=[
    "rename_var",
    "rename_func", 
    "add_dead_code",
    
    ] 
    
MT_OPERATE_EXPR_LIST=[
    "ExprStmt2Assign",
    "IfExpr2Stmt",
    "WhileStmt",
    "IfStmt2IfStmt",
    "AssginAddLine",
    "AugAssgin2Assign",
    "Comp2For",
    ]


class MutateModel:
    
    
    def __init__(self,rate=0.8, op_names = []):
        
        self.op_names = op_names
        assert len( set(op_names ) -  set(MT_OPERATE_RENAME_LIST+MT_OPERATE_EXPR_LIST)  ) ==0 , (op_names, MT_OPERATE_EXPR_LIST , MT_OPERATE_RENAME_LIST)
        
        self._rate = rate 
        # self.obj_rename_func =  rename_processor(lang="python", )
        # self.obj_rename_func.load_names()
        
        expr_operator_list = [x for x in op_names if x in MT_OPERATE_EXPR_LIST ]
        
        self.obj_expr_func =  ExprProcessor(operator_list=expr_operator_list, )
        
        
        
        
        
    def __call__(self,code  ):
        code_mt = code 

        if "rename_var" in self.op_names:
            code_mt = mt_rename(python_code=code_mt ,rate=self._rate )
        if "rename_func" in self.op_names:
            code_mt = mt_func_rename(python_code=code_mt ,rate=self._rate )

        if "add_dead_code" in self.op_names:
            code_mt =mt_deadcode(code_src= code )
        
        code_mt = self.obj_expr_func.run(code_content = code_mt )
        
        return code_mt 

    # def rename_imp(self,code, rate=None, indent=True, add_dead_code=True, cut_ratio=0.0, **kwargs  ):
    #     self.obj_rename_func.clear()
    #     self.obj_rename_func . _update(code=code )
    #
    #     kwargs["is_rename_var"]="rename_var" in self.op_names 
    #     kwargs["is_rename_func"]="rename_func" in self.op_names  
    #     kwargs["add_dead_code"]="add_dead_code" in self.op_names  
    #
    #     code_mt = self.obj_rename_func. process( 
    #         ratio=self._rate if rate is None else float(rate), 
    #         indent=indent,  cut_ratio=cut_ratio ,  **kwargs )
    #
    #     code_reversed = self.obj_rename_func.convert_to_normal(code=code_mt)
    #
    #     self.obj_rename_func.clear()
    #
    #     return code_reversed 
    #




