import ast
import copy
import random

import astor
import json 

import re
from tokenize import tokenize, untokenize, COMMENT, STRING, NEWLINE, ENCODING, ENDMARKER, NL, INDENT, NUMBER
from io import BytesIO
import json
import string

import os 

lits = json.load(open( os.path.join(os.path.dirname(__file__), "literals.json") ) )

# print ("fns", fns )
# lits = json.load(open("literals.json"))


def visit(node, nodes, pindex):
    if hasattr(node, 'name'):
        name = node.name
    elif hasattr(node, 'id'):
        name = node.id
    else:
        name = str(type(node).__name__)
    if type(node) == ast.Constant:
        name = '{}:{}'.format(type(node.value).__name__, node.value)
    if type(node) == ast.Attribute:
        name = '{}:{}'.format(type(node).__name__, node.attr)
    if type(node) == ast.FunctionDef:
        name = '{}:{}'.format('def', node.name)
    if type(node) == ast.Store:
        return
    index = len(nodes)
    nodes.append(index)
    for n in ast.iter_child_nodes(node):
        n.parent = node
        visit(n, nodes, index)


def process_string(token, special_chars={" ": "U+0020", ",": "U+002C"}):
    str_quote_options = ["'''", '"""', "'", '"']
    start_quote = ""
    end_quote = ""
    qualifier_regex = r"^[a-zA-Z]+"
    qualifier_match = re.search(qualifier_regex, token)
    # string qualifiers like 'r' for regex, 'f' for formatted string, 'b' for bytes, 'u' for unicode, etc (or combination of them)
    qualifier = "" if not qualifier_match else qualifier_match[0]
    # token string without qualifiers
    token_string = re.sub(qualifier_regex, "", token)
    # string literal without quotes
    str_lit = token_string
    for q in str_quote_options:
        if token_string.startswith(q):
            start_quote = q
            str_lit = str_lit[len(q) :]
            if token_string.endswith(q):
                end_quote = q
                str_lit = str_lit[: -len(q)]
            break
    # if start_quote in str_quote_options[:2]:
    #     return ""
    for sc in special_chars:
        str_lit = str_lit.replace(sc, special_chars[sc])
    return (
        f"{qualifier}{start_quote}<STR_LIT:{str_lit}>{end_quote}"
        if str_lit in lits['str']
        else f"{qualifier}{start_quote}<STR_LIT>{end_quote}"
    )



def find_parent(seed_nodes):
    i = 0
    while i < len(seed_nodes):
        node = seed_nodes[i]
        if hasattr(node, 'parent'):
            if type(node) != ast.FunctionDef and type(node) != ast.Module:
                if node.parent not in seed_nodes and hasattr(node.parent, 'lineno'):
                    seed_nodes.append(node.parent)
            i += 1
            continue
        i += 1
    return None
def findCondition(nodes):
    condition_nodes = []
    for node in nodes:
        if type(node)== ast.Compare:
            condition_nodes.append(node)
            src = astor.to_source(node)
            # print(src)
    return condition_nodes

def get_scope(node):
    scope_name = node.name
    while node is not None and hasattr(node, 'parent'):
        if type(node) == ast.FunctionDef or type(node) == ast.ClassDef:
            scope_name = node.name + '.' + scope_name
        node = node.parent
    return scope_name

def findIdentifier(tree):
    name_set = set()
    scope_list={'#root':{'##scope##':(0, 0)}}
    var_locs = scope_list['#root']
    stack = [tree]
    scope_name = '#root'
    current_func_name = '#root'
    current_parent_node = None
    while stack:
        curr_node = stack.pop()
        if hasattr(curr_node, 'parent'):
            if curr_node.parent == current_parent_node and scope_name!='#root':
                scope_name = scope_name[:scope_name.rfind('.')]
                if scope_name not in scope_list:
                    scope_list[scope_name] = {'##scope##':(curr_node.lineno, curr_node.end_lineno)}
        if isinstance(curr_node, ast.FunctionDef) or isinstance(curr_node, ast.ClassDef):
            scope_name = scope_name+ '.' + curr_node.name
            if scope_name not in scope_list:
                scope_list[scope_name] = {'##scope##':(curr_node.lineno, curr_node.end_lineno)}
            current_parent_node = curr_node.parent
        for _, value in ast.iter_fields(curr_node):
            if isinstance(value, list):
                for item in value:
                    if isinstance(item, ast.AST):
                        stack.append(item)
            elif isinstance(value, ast.AST):
                stack.append(value)
        node = curr_node
        if isinstance(curr_node, ast.Name):
            name_set.add(curr_node.id)
            var_locs = scope_list[scope_name]
            var_name = node.id
            # if var_name == "input_feed":
            #     print()
            if var_name not in var_locs:
                var_locs[var_name] = {
                    "assign": [],
                    "use": []
                }
            if isinstance(node.ctx, ast.Store):
                var_locs[var_name]["assign"].append((node.lineno, node.col_offset))
            elif isinstance(node.ctx, ast.Load):
                var_locs[var_name]["use"].append((node.lineno, node.col_offset))
    return scope_list, name_set

def generate_random_name(name_set=set()):
    # 生成随机长度
    length = random.randint(3, 10)

    # 生成随机字母序列
    letters = string.ascii_lowercase
    while True:
        function_name = ''.join(random.choice(letters) for _ in range(length))
        if function_name not in name_set:
            name_set.add(function_name)
            break

    return function_name




def findIfExpr(tree):
    if_expr_nodes = []
    for node in ast.walk(tree):
        if type(node) == ast.IfExp:
            if_expr_nodes.append(node)
    return if_expr_nodes

def mutateIfExpr2Stmt(nodes):
    action_list=[]
    first_node = nodes[0]
    first_parent_node= first_node.parent 
    
    assert type(first_parent_node)==ast.Assign 

    
    
    for node in nodes:
        def create_if_stmt(test, body, orelse):
            return ast.If(test=test, body=body, orelse=orelse)

        # Helper function to replace an IfExp node with an If node
        def replace_ifexpr_with_if(node):
            # Create the new If node
            if_stmt = create_if_stmt(node.test, [ast.Assign(targets=node.parent.targets, value=node.body)], [ast.Assign(targets=node.parent.targets, value=node.orelse)])

            # Replace the IfExp node with the new If node
            ast.copy_location(if_stmt, node)
            ast.fix_missing_locations(if_stmt)
            return if_stmt

        # Walk the syntax tree and replace IfExp nodes with If nodes
        if isinstance(node, ast.IfExp):
            if hasattr(node.parent, 'targets'):
                # v1= node.col_offset
                if_stmt = replace_ifexpr_with_if(node)
                # v2 = if_stmt.col_offset
                if_str = astor.to_source(if_stmt)
                # v3 = node.parent.lineno
                
                if node.parent.lineno == node.lineno and node.lineno == node.end_lineno:
                    action_list.append((first_parent_node.col_offset , 'IfExpr2Stmt', 'all',[node.parent.lineno], if_str,if_stmt))
    
    # print (action_list, "in IfExpr2Stmt")
    return action_list

def notConditon(test):
    orig_test = test
    condition_list = []
    condition_list.append(ast.UnaryOp(op=ast.Not(), operand=test))
    if hasattr(test, 'op'):
        test = copy.copy(test)
        if type(test.op)==ast.Eq:
            test.op = ast.NotEq()
        elif type(test.op)==ast.NotEq:
            test.op = ast.Eq()
        elif type(test.op)==ast.Lt:
            test.op = ast.GtE()
        elif type(test.op)==ast.LtE:
            test.op = ast.Gt()
        elif type(test.op)==ast.Gt:
            test.op = ast.LtE()
        elif type(test.op)==ast.GtE:
            test.op = ast.Lt()
        elif type(test.op)==ast.Is:
            test.op = ast.IsNot()
        elif type(test.op)==ast.IsNot:
            test.op = ast.Is()
        elif type(test.op)==ast.In:
            test.op = ast.NotIn()
        elif type(test.op)==ast.NotIn:
            test.op = ast.In()
        elif type(test.op)==ast.Not:
            test = test.operand
        condition_list.append(test)
    if hasattr(orig_test,'ops') and type(orig_test) == ast.Compare:
        test = copy.copy(orig_test)
        if len(test.ops)==1:
            if type(test.ops[0]) == ast.Eq:
                test.ops = [ast.NotEq()]
            elif type(test.ops[0]) == ast.NotEq:
                test.ops = [ast.Eq()]
            elif type(test.ops[0]) == ast.Lt:
                test.ops =[ast.GtE()]
            elif type(test.ops[0]) == ast.LtE:
                test.ops =[ast.Gt()]
            elif type(test.ops[0]) == ast.Gt:
                test.ops =[ast.LtE()]
            elif type(test.ops[0]) == ast.GtE:
                test.ops =[ast.Lt()]
            elif type(test.ops[0]) == ast.Is:
                test.ops =[ast.IsNot()]
            elif type(test.ops[0]) == ast.IsNot:
                test.ops =[ast.Is()]
            elif type(test.ops[0]) == ast.In:
                test.ops =[ast.NotIn()]
            elif type(test.ops[0]) == ast.NotIn:
                test.ops =[ast.In()]
            condition_list.append(test)
    return condition_list

def negate_if_expr(nodes):
    """
    将 if 表达式的 test 取反，同时调换 body 和 orelse 的位置

    :param if_expr: ast.If 表达式
    :return: 修改后的 ast.If 表达式
    """
    action_list = []
    for if_expr in nodes:
    # 取反 test
        if not hasattr(if_expr.parent, 'targets'):
            continue
        new_test_list = notConditon(if_expr.test)

        # 调换 body 和 orelse
        for test in new_test_list:
            new_test = test
            new_body = if_expr.orelse
            new_orelse = if_expr.body

            # 生成修改后的 if 表达式
            new_if_expr = ast.IfExp(test=new_test, body=new_body, orelse=new_orelse)
            new_if_str = astor.to_source(ast.Assign(targets = if_expr.parent.targets, value=new_if_expr))
            if if_expr.parent.lineno == if_expr.lineno:
                action_list.append((if_expr.parent.col_offset, 'negate_if_expr','all',[if_expr.parent.lineno,if_expr.parent.end_lineno], new_if_str))



    return action_list

def findAssgin(tree):
    assign_nodes = []
    for node in ast.walk(tree):
        if type(node) == ast.Assign:
            if type(node.value) == ast.List or type(node.value) == ast.Tuple or type(node.value) == ast.Set or type(node.value) == ast.Dict or type(node.value) == ast.Call:
                assign_nodes.append(node)
    
    # print ("assign_nodes,", assign_nodes)
    # if len(assign_nodes) >100:
    #     assign_nodes = random.sample(assign_nodes, 100)
    return assign_nodes

def mutateAssginAddLine(nodes):
    action_list = []
    for node in nodes:
        flag=0
        for n in ast.walk(node):
            if type(n) == ast.Constant and type(n.value) == str:
                if n.value.find('{') != -1 or n.value.find('}') != -1 or n.value.find('[') != -1 or n.value.find(']') != -1 or n.value.find('(') != -1 or n.value.find(')') != -1:
                    flag=1
        if node.lineno == node.end_lineno and flag==0:
            new_node_str = astor.to_source(node)
            action_list.append((node. col_offset , 'AssginAddLine','all',[node.lineno], new_node_str))
    return action_list
def findLambda(tree):
    lambda_nodes = []
    for node in ast.walk(tree):
        if type(node) == ast.Lambda:
            lambda_nodes.append(node)
    return lambda_nodes



def mutateLambda2func(nodes, name_set=set()):
    action_list = []
    for lambda_expr in nodes:
        args = lambda_expr.args
        body = lambda_expr.body
        name=generate_random_name(name_set)
        # 生成函数定义节点
        func_def = ast.FunctionDef(
            name=name,  # 使用特殊名称 '<lambda>'
            args=args,
            body=[ast.Return(value=body)],  # 将主体内容放到函数体中并使用 Return 语句返回
            decorator_list=[],
            returns=None
        )
        func_str = astor.to_source(func_def)
        parent = lambda_expr.parent
        while not hasattr(parent.parent, 'body') or (type(parent.parent)==ast.Lambda or type(parent.parent)==ast.Expression):
            parent = parent.parent
        if not hasattr(parent,'lineno'):
            continue
        action_list.append((node.col_offset , 'Lambda2Func','all',[parent.lineno], func_str,(lambda_expr.lineno,lambda_expr.end_lineno,lambda_expr.col_offset,lambda_expr.end_col_offset),name,(func_def)))
    return action_list



def findComp(tree):
    comp_nodes = []
    for node in ast.walk(tree):
        if type(node) == ast.ListComp or type(node) == ast.SetComp or type(node) == ast.DictComp:
            comp_nodes.append(node)
    return comp_nodes


def mutateComp2For(nodes):
    action_list = []
    for node in nodes:
        if hasattr(node.parent, 'targets'):
            generators = node.generators
            target = node.parent.targets[0]
            # 构造等价的完整语句
            if type(node) == ast.ListComp:
                elt = node.elt
                temp = ast.Assign(targets=[target], value=ast.List(elts=[], ctx=ast.Load()))
                loop_body = [ast.Expr(
                    value=ast.Call(func=ast.Attribute(value=target, attr='append', ctx=ast.Load()), args=[elt],
                                   keywords=[]))]
            elif type(node) == ast.SetComp:
                elt = node.elt
                temp = ast.Assign(targets=[target], value=ast.Set(elts=[]))
                loop_body = [ast.Expr(
                    value=ast.Call(func=ast.Attribute(value=target, attr='add', ctx=ast.Load()), args=[elt], keywords=[]))]
            elif type(node) == ast.DictComp:
                temp = ast.Assign(targets=[target], value=ast.Dict(keys=[], values=[]))
                loop_body = [ast.Assign(targets=[ast.Subscript(value=target, slice=ast.Index(value=node.key), ctx=ast.Store())],
                                        value=node.value)]
            for generator in reversed(generators):
                if generator.ifs:
                    cond = generator.ifs[0]
                    loop_body = [ast.For(target=generator.target, iter=generator.iter,
                                         body=[ast.If(test=cond, body=loop_body, orelse=[])], orelse=[], type_comment=None)]
                else:
                    loop_body = [
                        ast.For(target=generator.target, iter=generator.iter, body=loop_body, orelse=[], type_comment=None)]
            if node.lineno == node.end_lineno:
                ass_str = astor.to_source(temp)
                for_str = astor.to_source(loop_body[0])
                action_list.append((node.col_offset , "Comp2For",'all',[node.lineno],ass_str+for_str,(temp,loop_body)) )
    return action_list



def findExprStmt(tree):
    ExpStmt_nodes = []
    for node in ast.walk(tree):
        if type(node) == ast.Expr and type(node.parent) != ast.Assign:
            ExpStmt_nodes.append(node)
    return ExpStmt_nodes

# def mutateExprStmt2Assign(nodes,name_set):
#     action_list=[]
#     for node in nodes:
#         name = generate_random_name(name_set)
#         if node.lineno == node.end_lineno:
#             if hasattr(node.parent, 'body'):
#                 if node in node.parent.body:
#                     action_list.append(("ExprStmt2Assign",'all',[node.lineno],name+'='))
#     # if len(action_list) >100:
#     #     action_list = random.sample(action_list,100)
#     return action_list

def mutateExprStmt2Assign(nodes,name_set):
    action_list=[]
    for node in nodes:
        name = generate_random_name(name_set)
        if node.lineno == node.end_lineno:
            if hasattr(node.parent, 'body'):
                if node in node.parent.body:
                    ass_str_node = astor.to_source(node)
                    action_list.append((node.col_offset , "ExprStmt2Assign",'all',[node.lineno],name+'='+ass_str_node))
    # if len(action_list) >100:
    #     action_list = random.sample(action_list,100)
    return action_list



def findAugAssginStmt(tree):
    aug_Assgin_Stmt_nodes = []
    for node in ast.walk(tree):
        if type(node) == ast.AugAssign:
            aug_Assgin_Stmt_nodes.append(node)
    return aug_Assgin_Stmt_nodes

def mutateAugAssgin2Assgin(nodes):
    action_list=[]
    for node in nodes:
        new_assgin = ast.Assign(
            targets=[node.target],
            value=ast.BinOp(left=node.target, right=node.value, op=node.op)
        )
        new_str = astor.to_source(new_assgin)
        if node.lineno == node.end_lineno:
            action_list.append((node.col_offset , "AugAssgin2Assgin",'all',[node.lineno],new_str))
    return action_list

def findAssert(tree):
    assert_stmts = []
    for node in ast.walk(tree):
        if type(node) == ast.Assert:
            assert_stmts.append(node)
    return assert_stmts

def mutateAssert(nodes):
    action_list = []
    for node in nodes:
        new_test_list = notConditon(node.test)
        for new_test in new_test_list:
            new_node = ast.If(
                test=new_test,
                body=[ast.Raise(exc=ast.Call(func=ast.Name(id='AssertionError',ctx=ast.Load()),keywords=[],args=[node.msg]),cause=None)],
                orelse=[]
            )
            new_str = astor.to_source(new_node)
            if node.lineno == node.end_lineno:
                action_list.append((node.col_offset , "Assert2If",'all',[node.lineno],new_str))
    return action_list

def findIfStmt(tree):
    if_stmts = []
    for node in ast.walk(tree):
        if type(node) == ast.If:
            if_stmts.append(node)
    return if_stmts

def mutateIfStmt(nodes):
    action_list = []
    for node in nodes:
        if len(node.orelse) == 0:
            continue
        if type(node.parent) == ast.If:
            if  len(node.parent.orelse) == 1 and type(node.parent.orelse[0]) == node:
                continue
        elif len(node.orelse) == 1 and type(node.orelse[0]) == ast.If:
            root_node = copy.copy(node)
            new_node = root_node
            new_node.test = random.choice(notConditon(new_node.test))
            # new_node.body, new_node.orelse = new_node.orelse, new_node.body
            tmp_or = new_node.orelse
            tmp_body = new_node.body
            
            new_node.body, new_node.orelse =tmp_or ,tmp_body #  new_node.orelse, new_node.body
            # while len(new_node.body) == 1 and type(new_node.body[0]) == ast.If:
            #     new_node = new_node.body[0]
            #     new_node.test = random.choice(notConditon(new_node.test))
            #     new_node.body, new_node.orelse = new_node.orelse, new_node.body
            #     if type(new_node) != ast.If:
            #         break
            new_node = root_node
            new_str = astor.to_source(new_node)
            # print ("if ...1\n", new_str )
            action_list.append((node.col_offset , "IfStmt2IfStmt1",'all',[node.lineno,node.end_lineno],new_str))
        else:
            new_test_list = notConditon(node.test)
            for new_test in new_test_list:
                new_node = ast.If(
                    test=new_test,
                    body=node.orelse,
                    orelse=node.body
                )
                new_str = astor.to_source(new_node)
                action_list.append((node.col_offset , "IfStmt2IfStmt2", 'all', [node.lineno, node.end_lineno], new_str))
    return action_list

def findWhileStmt(tree):
    while_stmts = []
    for node in ast.walk(tree):
        if type(node) == ast.While:
            while_stmts.append(node)
    return while_stmts

def mutateWhileStmt(nodes):
    action_list = []
    for node in nodes:
        new_test_list = notConditon(node.test)
        for new_test in new_test_list:
            stop_line = ast.If(
                test = new_test,
                body=[ast.Break()],
                orelse=[]
            )
            new_node = ast.While(
                test=ast.Constant(value=True, kind=None),
                body=[stop_line]+node.body,
                orelse=node.orelse
            )
            new_str = astor.to_source(new_node)
            action_list.append((node.col_offset , "WhileStmt", 'all', [node.lineno, node.end_lineno], new_str))
    return action_list

def findForStmt(tree):
    for_stmts = []
    for node in ast.walk(tree):
        if type(node) == ast.For:
            for_stmts.append(node)
    return for_stmts

def mutateForStmt(nodes,name_set):
    action_list = []
    for node in nodes:
        # use iter replace for loop
        name = generate_random_name(name_set)
        ass_line = ast.Assign(targets=[ast.Name(id=name, ctx=ast.Store())], value=node.iter)
        try_scope = ast.Try(
            body=[ast.Assign(targets=[node.target], value=ast.Call(func=ast.Name(id='next',ctx=ast.Load()),args=ass_line.targets,keywords=[]))]+node.body,
            handlers=[ast.ExceptHandler(type=ast.Name(id='StopIteration', ctx=ast.Load()), name=None, body=[ast.Break()])],
            orelse=[],
            finalbody=[]
        )
        new_node = ast.While(
            test=ast.Constant(value=True, kind=None),
            body=[try_scope],
            orelse=node.orelse
        )
        new_ass_str = astor.to_source(ass_line)
        new_str = astor.to_source(new_node)
        action_list.append((node.col_offset , "ForStmt", 'all', [node.lineno, node.end_lineno], new_ass_str+new_str))
    return action_list

def findWithStmt(tree):
    with_stmts = []
    for node in ast.walk(tree):
        if type(node) == ast.With:
            with_stmts.append(node)
    return with_stmts

def mutateWith2Try(nodes):
    action_list=[]
    for node in nodes:
        ctx_expr = node.items[0].context_expr
        optional_vars = node.items[0].optional_vars
        if optional_vars==None:
            continue
        body = node.body

        # 构造try语句
        try_node = ast.Try(
            body=body,
            handlers=[],
            orelse=[],
            finalbody=[]
        )

        # 构造with语句的退出代码
        exit_call = ast.Call(
            func=ast.Attribute(
                value=optional_vars,
                attr="__exit__",
                ctx=ast.Load()
            ),
            args=[
                ast.Name(
                    id="None",
                    ctx=ast.Load()
                ),
                ast.Name(
                    id="None",
                    ctx=ast.Load()
                ),
                ast.Name(
                    id="None",
                    ctx=ast.Load()
                )
            ],
            keywords=[]
        )
        exit_expr = ast.Expr(value=exit_call)

        # 构造try语句的finally块
        try_node.finalbody.append(exit_expr)

        # 构造with语句的进入代码
        enter_call = ast.Call(
            func=ast.Attribute(
                value=ctx_expr,
                attr="__enter__",
                ctx=ast.Load()
            ),
            args=[],
            keywords=[]
        )
        enter_expr = ast.Expr(value=ast.Assign(
            targets=[optional_vars],
            value=enter_call
        ))

        # 将try语句和进入代码合并为一个新的块
        ctx_str = astor.to_source(enter_expr) + astor.to_source(try_node)
        action_list.append((node.col_offset, "With2Try", 'all', [node.lineno, node.end_lineno], ctx_str))
    return action_list

def findScope2Func(tree):
    zip_Scope = []
    for node in ast.walk(tree):
        if hasattr(node, 'body'):
            if len(node.body) > 5:
                start = random.randint(0, len(node.body))
                if start + 5 < len(node.body):
                    end = random.randint(start+2, start + 5)
                else:
                    end = random.randint(start, len(node.body))
                zip_Scope.append(node.body[start:end])
    return zip_Scope

def mutateZipScope(nodes,name_set):
    action_list = []
    # print ("nodes.mutateZipScope", nodes)
    for scope in nodes:
        func_name = generate_random_name(name_set)
        load_var = set()
        load_name = set()
        arg_var=set()
        arg_name=set()
        store_var = set()
        store_name = set()
        start_line = scope[0].lineno
        end_line = scope[-1].end_lineno
        return_var=[]
        for line in scope:
            return_var+=line.targets
            for node in ast.walk(line):
                if type(node) == ast.Name and isinstance(node.ctx, ast.Load):

                    if type(node.parent) == ast.Call:
                        if node.parent.func==node:
                            continue
                    if type(node.parent) == ast.ExceptHandler:
                        if node.parent.type==node:
                            continue
                    if node.id not in load_name:
                        load_var.add(node)
                        load_name.add(node.id)
                    if node.id not in arg_name:
                        arg_var.add(ast.arg(arg=node.id, annotation=None))
                        arg_name.add(node.id)
                if type(node) == ast.Name and isinstance(node.ctx, ast.Store):
                    if node.id not in store_name:
                        store_name.add(node.id)
                        store_var.add(node)
        return_node = ast.Return(value=ast.Tuple(elts=return_var,ctx = ast.Load()))
        new_node = ast.Assign(targets = [ast.Tuple(elts=return_var,ctx = ast.Store())], value = ast.Call(func=ast.Name(id=func_name,ctx=ast.Load()),args=load_var,keywords=[]))
        use_str = astor.to_source(new_node)
        func_node = ast.FunctionDef(name=func_name, args=ast.arguments(args=arg_var, vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=scope+[return_node], decorator_list=[], returns=None)
        def_str = astor.to_source(func_node)
        action_list.append((scope[0].col_offset , "Scope2Func", 'all', [start_line, end_line], def_str+use_str))
    return action_list

def zipAssgin(tree):
    zip_Assgin = []
    for node in ast.walk(tree):
        if hasattr(node, 'body'):
            i = 0
            while i < len(node.body):
                sub_list = []
                if type(node.body[i]) == ast.Assign and len(node.body[i].targets) == 1:
                    sub_list.append(node.body[i])
                    while i+1 < len(node.body) and type(node.body[i+1]) == ast.Assign and len(node.body[i].targets) == 1:
                        sub_list.append(node.body[i+1])
                        i += 1
                i += 1
            if len(sub_list) > 1:
                zip_Assgin.append(sub_list)
    return zip_Assgin

def mutateZipAssgin(nodes):
    action_list = []
    for nodes_x in nodes:
        targets = []
        values = []
        for node in nodes_x:
            targets.append(node.targets[0])
            values.append(node.value)
        new_node = ast.Assign(targets=[ast.Tuple(elts=targets,ctx=ast.Store())], value=ast.Tuple(elts=values, ctx=ast.Load()))
        new_str = astor.to_source(new_node)
        action_list.append((nodes_x[0].col_offset, "ZipAssgin", 'all', [nodes_x[0].lineno, nodes_x[-1].end_lineno], new_str))
    return action_list






def analyzeCode(tree):
    
    code_reverse = astor.to_source(tree)
    # print ("analyzeCode", code_reverse) 
    
    if_expr_nodes = []
    assign_nodes = []
    lambda_nodes = []
    comp_nodes = []
    ExpStmt_nodes = []
    aug_Assgin_Stmt_nodes = []
    assert_stmts = []
    if_stmts = []
    while_stmts = []
    for_stmts = []
    with_stmts = []
    zip_Scope = []
    zip_Assgin = []
    add_GarbageCode = []
    for node in ast.walk(tree):
        if type(node) == ast.IfExp:
            if_expr_nodes.append(node)
        if type(node) == ast.Assign:
            if type(node.value) == ast.List or type(node.value) == ast.Tuple or type(node.value) == ast.Set or type(
                    node.value) == ast.Dict or type(node.value) == ast.Call:
                assign_nodes.append(node)
        if type(node) == ast.Lambda:
            lambda_nodes.append(node)
        if type(node) == ast.ListComp or type(node) == ast.SetComp or type(node) == ast.DictComp:
            comp_nodes.append(node)
        if type(node) == ast.Expr and type(node.parent) != ast.Assign and type(node.parent) != ast.AugAssign and type(
                node.parent) != ast.Module:
            ExpStmt_nodes.append(node)
        if type(node) == ast.AugAssign:
            aug_Assgin_Stmt_nodes.append(node)
        if type(node) == ast.Assert:
            assert_stmts.append(node)
        if type(node) == ast.If:
            if_stmts.append(node)
        if type(node) == ast.While:
            while_stmts.append(node)
        if type(node) == ast.For:
            for_stmts.append(node)
        if type(node) == ast.With:
            with_stmts.append(node)
        if hasattr(node, 'body') and isinstance(node.body, list):
            if len(node.body) > 3:
                start = random.randint(0, len(node.body))
                if start + 3 < len(node.body):
                    end = random.randint(start+2, start + 3)
                else:
                    end = random.randint(start, len(node.body))
                sub_scope = node.body[start:end]
                flag=0
                if len(sub_scope) > 1:
                    for sub_node in sub_scope:
                        if type(sub_node) != ast.Assign:
                            flag=1
                        else:
                            for store in sub_node.targets:
                                if type(store) != ast.Name:
                                    flag=1
                    if flag == 0 and node.body[end-1].end_lineno-node.body[start].lineno<20 :
                        zip_Scope.append(node.body[start:end])
                        # varx = node.body[start:end]
                        # if type(varx)==list :
                        #     zip_Scope.append( varx[0] )
                        # else:
                        #     zip_Scope.append( varx )
                        
        if hasattr(node, 'body') and isinstance(node.body, list):
            # for sub_node in node.body:
            #     add_GarbageCode.append(sub_node.lineno)
            i = 0
            while i < len(node.body):
                sub_list = []
                used_name = set()
                flag_use = 0
                if type(node.body[i]) == ast.Assign and len(node.body[i].targets) == 1:
                    sub_list.append(node.body[i])
                    if type(node.body[i].targets[0]) == ast.Name:
                        used_name.add(node.body[i].targets[0].id)
                    if type(node.body[i].targets[0]) == ast.Attribute:
                        used_name.add(astor.to_source(node.body[i].targets[0]))
                    while i+1 < len(node.body) and type(node.body[i+1]) == ast.Assign and len(node.body[i].targets) == 1:
                        for _sub_sub in ast.walk(node.body[i+1]):
                            if type(_sub_sub) == ast.Name:
                                if _sub_sub.id in used_name:
                                    flag_use=1
                                    break
                            if type(_sub_sub) == ast.Attribute:
                                if astor.to_source(_sub_sub) in used_name:
                                    flag_use = 1
                                    break
                        if flag_use == 1:
                            flag_use = 0
                            break
                        sub_list.append(node.body[i+1])
                        i += 1
                i += 1
            if len(sub_list) > 1:
                zip_Assgin.append(sub_list)
                # if type(varx)==list :
                #     zip_Assgin.extend( varx  )
                # else:
                #     zip_Assgin.append( varx )
                

                
    return dict(
        IfExpr2Stmt=if_expr_nodes,
        AssginAddLine=assign_nodes,
        Lambda2Func=lambda_nodes,
        Comp2For=comp_nodes,
        ExprStmt2Assign=ExpStmt_nodes,
        AugAssgin2Assign=aug_Assgin_Stmt_nodes,
        Assert2If=assert_stmts,
        IfStmt2IfStmt=if_stmts,
        WhileStmt=while_stmts,
        ForStmt=for_stmts,
        With2Try=with_stmts,
        Scope2Func=zip_Scope,
        ZipAssgin=zip_Assgin,
        # GarbageCode=add_GarbageCode,
        )

# if_Expr, assgin_Expr, lambda_Expr, comp_Expr, expr_Stmts, assgin_Stmts, assert_Stmts, if_Stmts, while_Stmts, for_Stmts, with_Stmts, zip_Scope, zip_Assgin, add_gbg_code = analyzeCode(tree)


# # use analyzer to find the nodes we want to mutate
# if_Expr, assgin_Expr, lambda_Expr, comp_Expr, expr_Stmts, assgin_Stmts, assert_Stmts, if_Stmts, while_Stmts, for_Stmts, with_Stmts, zip_Scope, zip_Assgin, add_gbg_code = analyzeCode(
#     tree)
# print ("done2")
# action_list = []
# action_list += mutateIfExpr2Stmt(if_Expr)
# print ("done3")
# action_list += negate_if_expr(if_Expr)
# action_list += mutateAssginAddLine(assgin_Expr)
# action_list += mutateLambda2func(lambda_Expr, name_set)
# action_list += mutateComp2For(comp_Expr)
# action_list += mutateExprStmt2Assign(expr_Stmts, name_set)
# action_list += mutateAugAssgin2Assgin(assgin_Stmts)
# action_list += mutateAssert(assert_Stmts)
# action_list += mutateIfStmt(if_Stmts)
# action_list += mutateWhileStmt(while_Stmts)
# action_list += mutateForStmt(for_Stmts, name_set)
# action_list += mutateWith2Try(with_Stmts)
# action_list += mutateZipScope(zip_Scope, name_set)
# action_list += mutateZipAssgin(zip_Assgin)
# action_list += [('GarbageCode', 'all', [0])] * 3
# action_list += [('GarbageCode', 'near', [0])]
# # print(action_list)


