import ast 
import random

# random.seed(10)
import astor 
import string 

# def _generate_random_name( name_set=set()):
#     # 生成随机长度
#     length = random.randint(3, 10)
#
#     # 生成随机字母序列
#     letters = string.ascii_lowercase
#     while True:
#         function_name = ''.join(random.choice(letters) for _ in range(length))
#         if function_name not in name_set:
#             name_set.add(function_name)
#             break
#     return function_name

from .utils import VAR_NAMES_MOST_COMMON, FUNC_NAMES_MOST_COMMON
from .utils import get_funcnames_from_code as get_all_funcnames
from .utils import get_varnames_from_code 


def create_obj_from_class( 
                          class_name="MyClass", 
                          B_func_name="function_name",
                          B_func_name_2param="function_name2",
                          instance_name="instance_name",
                          C_var_name="c_var",
                           ):
    ''''
def insert_deadcode_here():


    class MyClass:

        def function_name(self):
            self.data = ''
            return self.data

        def function_name2(self, float_var):
            self.data = ''
            return self.data
    instance_name = MyClass()

    def function_name2(str_arg1, str_arg2):
        str_arg1 = str(arg1)
        str_arg2 = str(arg2)
        result = str_arg1 + str_arg2
        return result
    c_var = None
    pass
    '''
    
    # 1. Create the class, attributes, and instance using ast nodes
    class_definition = ast.ClassDef(
        name=class_name,
        bases=[],
        keywords=[],
        body=[
            ast.FunctionDef(
                name=B_func_name,
                args=ast.arguments(
                    args=[
                        ast.arg(arg="self", annotation=None),
                    ],
                    defaults=[],
                    vararg=None,
                    kwonlyargs=[],
                    kw_defaults=[],
                ),
                body=[
                    ast.Assign(
                        targets=[ast.Attribute(
                            value=ast.Name(id="self", ctx=ast.Load()),
                            attr="data",
                            ctx=ast.Store(),
                        )],
                        value=ast.Constant(value=""),
                    ),
                    ast.Return(value=ast.Attribute(
                        value=ast.Name(id="self", ctx=ast.Load()),
                        attr="data",
                        ctx=ast.Load(),
                    )),
                ],
                decorator_list=[],
                # decorator_list=[ast.Name(id='overload', ctx=ast.Load()),],
            ),
            ast.FunctionDef(
                name=B_func_name_2param,
                args=ast.arguments(
                    args=[
                        ast.arg(arg="self", annotation=None),
                        ast.arg(arg="float_var", annotation=None  ),
                    ],
                    defaults=[ ast.Constant(value=None)],
                    vararg=None,
                    kwonlyargs=[],
                    kw_defaults=[],
                ),
                body=[
                    ast.Assign(
                        targets=[ast.Attribute(
                            value=ast.Name(id="self", ctx=ast.Load()),
                            attr="data",
                            ctx=ast.Store(),
                        )],
                        value=ast.Constant(value=""),
                    ),
                    ast.Return(value=ast.Attribute(
                        value=ast.Name(id="self", ctx=ast.Load()),
                        attr="data",
                        ctx=ast.Load(),
                    )),
                ],
                decorator_list=[],
                # decorator_list=[ast.Name(id='overload', ctx=ast.Load()),],
            ),
        ],
        decorator_list=[],
    )
    
    # Create an instance of the class
    instance_creation = ast.Assign(
        targets=[ast.Name(id=instance_name, ctx=ast.Store())],
        value=ast.Call(
            func=ast.Name(id=class_name, ctx=ast.Load()),
            args=[],
            keywords=[],
        )
    )
    
    static_func_creation=  ast.FunctionDef(
                name=B_func_name_2param,
                args=ast.arguments(
                    args=[
                        # ast.arg(arg="self", annotation=None),
                        ast.arg(arg="arg1", annotation=None, ),
                        ast.arg(arg="arg2", annotation=None, ),
                    ],
                    defaults=[ ast.Constant(value=None), ast.Constant(value=None)],
                    vararg=None,
                    kwonlyargs=[],
                    kw_defaults=[],
                ),
                body=[
                    ast.Assign(
                        targets=[ast.Name(id="arg1", ctx=ast.Store())],
                        value=ast.Call(
                            func=ast.Name(id="str", ctx=ast.Load()),  # Convert arg1 to a string
                            args=[ast.Name(id="arg1", ctx=ast.Load())],
                            keywords=[]
                        )
                    ),
                    ast.Assign(
                        targets=[ast.Name(id="arg2", ctx=ast.Store())],
                        value=ast.Call(
                            func=ast.Name(id="str", ctx=ast.Load()),  # Convert arg2 to a string
                            args=[ast.Name(id="arg2", ctx=ast.Load())],
                            keywords=[]
                        )
                    ),
                    ast.Assign(
                        targets=[ast.Name(id="result", ctx=ast.Store())],
                        value=ast.BinOp(
                            left=ast.Name(id="arg1", ctx=ast.Load()),
                            op=ast.Add(),
                            right=ast.Name(id="arg2", ctx=ast.Load())
                        )
                    ),
                    ast.Return(value=ast.Name(id="result", ctx=ast.Load()))
                ],
                decorator_list=[],
             )
    
    # Create an instance of the class
    var_creation = ast.Assign(
        targets=[ast.Name(id=C_var_name, ctx=ast.Store())],
        value=ast.Constant(value=None)
    )

    # import_node = ast.ImportFrom(module="typing", names=[ast.alias(name="overload", asname=None)], level=0)
    
    return [class_definition,instance_creation, static_func_creation, var_creation ]


def add_deadcode(tree_node, name_set=set(), dead_type=random.randrange(0,6)):
    # dead code types, vars that can't appear in original code
    # A = B, A
    # A(B, 0), A
    # A = B + C, AB
    # A = B(C), AB
    # A = B.C(), ABC
    # A = [B for B in range(C)]
    # A = B if C else 0
    # dead_type = 3
    # dead_type = 4
    # dead_type = 5
    # dead_type = 6
    # A_name ="A_var" #_generate_random_name()
    # class_name ="B_Class" #_generate_random_name()
    # B_func_name ="B_func"# _generate_random_name()
    # instance_name = "B_instance"
    # B_func_name_2param ="B_func2"# _generate_random_name()
    # C_var_name ="C_vars"# _generate_random_name()
    
    A_name, instance_name, C_var_name= random.sample(VAR_NAMES_MOST_COMMON, 3 ) 
    class_name, B_func_name, B_func_name_2param= random.sample(FUNC_NAMES_MOST_COMMON, 3 ) 
    
    
    inserted_deadcode_nodes = create_obj_from_class(
                          class_name=class_name, 
                          B_func_name=B_func_name,
                          B_func_name_2param=B_func_name_2param,
                          instance_name=instance_name,
                          C_var_name=C_var_name) 

    # inserted_node  = [*inserted_deadcode_nodes]+ tree_node.body 
    call_nodes = [(l,) for l in inserted_deadcode_nodes]
    # return call_nodes

    if dead_type == 0:
        # return f"{v[0]} = {v[1]}"
        argss=[]
        #A=B()
        argss+=[dict(
            targets=[ast.Name(id=A_name, ctx=ast.Store())],
            value=ast.Call(func=ast.Name(id=class_name, ctx=ast.Load()),args=[], keywords=[] )
            )]
        #A=B
        argss+=[dict(
            targets=[ast.Name(id=A_name, ctx=ast.Store())],
            value=ast.Name(id=class_name, ctx=ast.Store()), 
            ) ]
        #A=C
        argss+=[dict(
            targets=[ast.Name(id=A_name, ctx=ast.Store())],
            value=ast.Constant(value=C_var_name)
            ) ]
        # args = random.sample(argss,1)
        # call_node  = ast.Assign(**args)
    
        call_nodes+= [(ast.Assign(**args),) for args in argss ]
    elif dead_type == 1:
        # A(B, 0), A
        # instance.B(A, 0), A
        init_assignment = ast.Assign(
            targets=[ast.Name(id=A_name, ctx=ast.Store())],
            value=ast.Constant(value=None)
        )
        # function_name,arg_name = A_name, B_func_name_2param
        function_ast = ast.Name(id=B_func_name_2param, ctx=ast.Load())
        args_ast = [ast.Name(id=A_name, ctx=ast.Load()), ast.Constant(id=None, value=0, ctx=ast.Load()),   ]
        call_node =ast.Expr(value= ast.Call(func=function_ast, args=args_ast, keywords=[]) )
        # return f"{v[0]}({v[1]}, 0)"
        call_nodes+= [(init_assignment, call_node)]
    #
    elif dead_type == 2:
        # A = B + C, AB
        call_node= ast.Assign(
                    targets=[ast.Name(id=A_name, ctx=ast.Store())],
                    value=ast.BinOp(
                        left=ast.Call(
                            func=ast.Attribute( value=ast.Name(id=instance_name, ctx=ast.Load()), attr=B_func_name, ctx=ast.Load() ),
                            args=[],keywords=[],
                            ),
                        op=ast.Add(),
                        right=ast.Call(
                            func= ast.Attribute(value=ast.Name(id=instance_name, ctx=ast.Load()), attr=B_func_name_2param,ctx=ast.Load() ),
                            args=[],keywords=[],
                            ),
                    ) 
                )
        # return f"{v[0]} = {v[1]} + {v[2]}"
        call_nodes+= [(call_node,)]
    #
    elif dead_type == 3:
        # A = B(C), AB
        # function_name,arg_name = A_name, B_func_name_2param
        function_ast = ast.Name(id=B_func_name_2param, ctx=ast.Load())
        args_ast = [ast.Name(id=B_func_name_2param, ctx=ast.Load())]
        call_node= ast.Assign(
                    targets=[ast.Name(id=A_name, ctx=ast.Store())],
                    value=ast.Call(func=function_ast, args=args_ast, keywords=[])  )
        # return f"{v[0]} = {v[1]}({v[2]})"
        call_nodes+= [(call_node,)]
    
    elif dead_type == 4:
        # A = B.C(), ABC
        call_node= ast.Assign(
                targets=[ast.Name(id=A_name, ctx=ast.Store())],
                value=ast.Attribute(value=ast.Name(id=instance_name, ctx=ast.Load()), 
                                    attr=B_func_name,ctx=ast.Store(),)
                )
    
        # return f"{v[0]} = {v[1]}.{v[2]}()"
        call_nodes+= [(call_node,)]
    
    elif dead_type == 5:
        # A = [B for B in range(C)]
        # Define the variable name and the iterator name
        variable_name = A_name
        iterator_name = B_func_name
        range_arg = C_var_name
    
        # Create the list comprehension
        list_comprehension = ast.ListComp(
            elt=ast.Name(id=iterator_name, ctx=ast.Load()),
            generators=[ast.comprehension(
                target=ast.Name(id=iterator_name, ctx=ast.Store()),
                iter=ast.Call(
                    func=ast.Name(id="range", ctx=ast.Load()),
                    args=[ast.Name(id=range_arg, ctx=ast.Load())],
                    keywords=[]
                ),
                ifs=[]
            )]
        )
        init_assignment = ast.Assign(
            targets=[ast.Name(id=C_var_name, ctx=ast.Store())],
            value=ast.Constant(value=random.randint(0,100))
        )
        # Create the assignment
        call_node = ast.Assign(
            targets=[ast.Name(id=variable_name, ctx=ast.Store())],
            value=list_comprehension
        )
        # return f"{v[0]} = [{v[1]} for {v[1]} in range({v[2]})]"
        call_nodes+= [(init_assignment, call_node)]

    elif dead_type == 6:
        # A = B if C else 0
        # Define the variable names and the condition
        variable_name = A_name
        value_name = B_func_name_2param
        condition_name = C_var_name
        
        # Create the conditional expression
        conditional_expression = ast.IfExp(
            test=ast.Name(id=condition_name, ctx=ast.Load()),
            body=ast.Name(id=value_name, ctx=ast.Load()),
            orelse=ast.Constant(value=0)
        )
        init_assignment = ast.Assign(
            targets=[ast.Name(id=C_var_name, ctx=ast.Store())],
            value=ast.Constant(value=None)
        )
        # Create the assignment
        call_node = ast.Assign(
            targets=[ast.Name(id=variable_name, ctx=ast.Store())],
            value=conditional_expression
        )
        call_nodes+= [(init_assignment,call_node)]

        # return f"{v[0]} = {v[1]} if {v[2]} else 0"
    return call_nodes 

class FunctionInsertionTransformer(ast.NodeTransformer):
    def visit_FunctionDef(self, node, **kwargs):
        # When a function definition is encountered, insert the custom node before it
        # self.dead_type=random.randrange(3,5) 
        for i in range(4):
            try :
                ast_nodes = add_deadcode(node  ) 
                build_nodes = []
                ast_nodes = random.sample(ast_nodes,1)
                [build_nodes.extend(list(l)) for l in ast_nodes ] 
                new_body =  build_nodes + node.body 
                node.body = new_body
            except :
                pass 
        return node

def mt_deadcode(code_src , insert_count = 1 , return_node =True  ):
    assert type(code_src) in [bytes,str] , type(code_src)
    python_tree_node =ast.parse(code_src)

    # ll_vars,_ = get_varnames_from_code(python_tree_node)
    # ll_vars = []
    # ll_funcs = get_all_funcnames(python_tree_node)
    # # print ( type(ll_vars), type(ll_funcs), "ll_funcs.ll_vars " )
    #
    # ll_funcs = ll_vars + ll_funcs
    #
    # selected_funcs = random.sample(ll_funcs,insert_count )
    #

    
    transformer = FunctionInsertionTransformer()
    dead_type = transformer.dead_type if hasattr(transformer,"dead_type") else  None 
    
    modified_ast = transformer.visit(python_tree_node)
            
    # if not return_node :
    #     new_code = astor.to_source( modified_ast )
    #     return  new_code
    #
    # return modified_ast
    #
    new_code = astor.to_source( modified_ast )
    
    # new_code += "\n #"+str(dead_type)
    
    return new_code 
    

    


