from typing import Union
import libcst as cst
from libcst.metadata import QualifiedNameProvider



import libcst.matchers as mmm

class FunctionRenamer(cst.CSTTransformer):
    def leave_Call(self, original_node: cst.Call, updated_node: cst.Call) -> cst.Call:
        if mmm.matches(updated_node.func, mmm.Name()):
            return updated_node.with_changes(
                func=cst.Name(
                    "renamed_" + cst.ensure_type(updated_node.func, cst.Name).value
                )
            )
        return updated_node

    def leave_Name(
        self, original_node: cst.Name, updated_node: cst.Name
    ) -> Union[cst.Attribute, cst.Name]:
        full_name_for_node: str = original_node.value
        full_replacement_name ="renamed_gen_"+full_name_for_node # self.gen_replacement(full_name_for_node)

        # If a node has no associated QualifiedName, we are still inside an import statement.
        inside_import_statement: bool = not self.get_metadata(
            QualifiedNameProvider, original_node, set()
        )
        if QualifiedNameProvider.has_name(self, original_node, self.old_name) or (
            inside_import_statement and full_replacement_name == self.new_name
        ):
            if not full_replacement_name:
                full_replacement_name = self.new_name
            if not inside_import_statement:
                self.scheduled_removals.add(original_node)
            return self.gen_name_or_attr_node(full_replacement_name)

        return updated_node




def rename_function_in_code(code, old_name, new_name):
    # Parse the code into an Abstract Syntax Tree (AST)
    module = cst.parse_module(code)

    # Create the visitor to rename functions
    visitor = FunctionRenamer()
    #visitor = RenameFunctionVisitor(old_name, new_name)

    # Apply the visitor to modify the CST
    new_module = module.visit(visitor)

    # Serialize the modified AST back to Python code
    new_code = new_module.code
    return new_code

# Example usage:
code = """
def old_function():
    return "Hello, World!"

new_car = old_function()
"""

new_code = rename_function_in_code(code, "old_function", "new_function")
print(new_code)

