
import numpy as np 

def metric_cal(y_true, y_prob ):

    
    from sklearn import metrics
    from scipy.optimize import brentq
    from scipy.interpolate import interp1d

    y_prob_label = y_prob>0.5 if "float" in str(y_prob.dtype)  else y_prob 
    y_prob_label = y_prob_label.astype(int)

    TN, FP, FN, TP  =\
        metrics.confusion_matrix(y_true = y_true, 
                         y_pred = y_prob_label, 
                         ).ravel()

    print (TN, FP, FN, TP,"cmt....")
    FPR = FP / float(FP+ TN + np.finfo(float).eps )
    TPR = TP/ float( TP+FN + np.finfo(float).eps)
    FNR = FN/ float( FN+TP +np.finfo(float).eps )

    _fpr, _tpr, thresholds = metrics.roc_curve(y_true, y_prob, pos_label=1)

    eer = brentq(lambda x : 1. - x - interp1d(_fpr, _tpr)(x), 0., 1.)

    
    auc = metrics.auc(_fpr, _tpr)
    return {
        "auc":auc,
        "fpr":FPR,
        "fnr":FNR,
        "eer":eer,
        }

if __name__=="__main__":
    
    a=np.array([1,1,1,1,1,1,1])
    b=np.array([1,1,0,1,0,1,1])
    
    score = metric_cal(y_true=a,y_prob=b)
    
    print (score )