
import json 
from ..base  import BaseRequest
from ..utils import api_call 

import pandas as pd 
import numpy as np 
import random 

import os 
cur = os.path.dirname(__file__)

import time 

class Imp(BaseRequest):
    
    def __init__(self, token=None ): 
        
        url = 'https://api.openai.com/v1/completions'
        super(Imp, self).__init__(url=url , return_rsp=False  )
        # self.
        
        # self.cookies={"accessToken":"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJhdXRoZW50aWNhdGVkIiwiZXhwIjoxNjc4MjY0MTIzLCJzdWIiOiIxN2M1MTJkZi0wYzg2LTQzMmEtOWU3Ni0wZjc5N2E4MjM1NzciLCJlbWFpbCI6InJlY2V0ZXk4OTBAd2lyb3V0ZS5jb20iLCJwaG9uZSI6IiIsImFwcF9tZXRhZGF0YSI6eyJwcm92aWRlciI6ImVtYWlsIiwicHJvdmlkZXJzIjpbImVtYWlsIl19LCJ1c2VyX21ldGFkYXRhIjp7ImVtYWlsIjoicmVjZXRleTg5MEB3aXJvdXRlLmNvbSIsImZ1bGxfbmFtZSI6InJlY2V0ZXk4OTAiLCJvcmciOiIifSwicm9sZSI6ImF1dGhlbnRpY2F0ZWQiLCJhYWwiOiJhYWwxIiwiYW1yIjpbeyJtZXRob2QiOiJwYXNzd29yZCIsInRpbWVzdGFtcCI6MTY3NzY1OTMyM31dLCJzZXNzaW9uX2lkIjoiOGJkMmFhMzktNDlmMi00ZGE0LWFlMGItZmM3ZTkyZTZjZGE1In0.thnop7Mbp9kCLC17q4I8ikDZkuOKk1bIopA8NjwXENQ"}
        
        self.headers .update({

            "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/110.0",
            "Accept": "*/*",
            "Accept-Language": "en-US,en;q=0.5",
            "Accept-Encoding": "gzip, deflate, br",
            "Referer": "https://platform.openai.com/",
            "Content-Type": "application/json",
            "Origin": "https://platform.openai.com",
            "Connection": "keep-alive",
            "Sec-Fetch-Dest": "empty",
            "Sec-Fetch-Mode": "cors",
            "Sec-Fetch-Site": "same-site",
            "TE": "trailers",
            
            # 'Accept': '*/*',
            # 'Accept-Language': 'en-US,en;q=0.9,hi;q=0.8',
            # 'Authorization': token,
            # 'Connection': 'keep-alive',
            # 'Content-Type': 'application/json',
            # 'Origin': 'https://platform.openai.com',
            # 'Referer': 'https://platform.openai.com/',
            # 'Sec-Fetch-Dest': 'empty',
            # 'Sec-Fetch-Mode': 'cors',
            # 'Sec-Fetch-Site': 'same-site',
            # 'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',
            # 'sec-ch-ua': '"Not_A Brand";v="99", "Google Chrome";v="109", "Chromium";v="109"',
            # 'sec-ch-ua-mobile': '?0',
            # 'sec-ch-ua-platform': '"macOS"',

            })

        self.method = "POST"
    
        self.possible_classes = ['very unlikely', 'unlikely', 'unclear if it is', 'possibly', 'likely']
        self.class_max = [10, 45, 90, 98, 99]


        self.gap_window= 10 
        self.rate_limit = api_call.RateLimit(rate_limit=100, window_size=10, func_name="openai_cls",gap_window=self.gap_window )
        
        
        
        self.inc= {}
        self.inc["sess"]=0
        self.inc["api"]= 0 

        cur_dir = os.path.dirname( __file__ )
        
        token_file = os.path.join(cur_dir, "activate_apis", "convert_api.jsonl" )
        # token_file = os.path.join(cur_dir, "activate_apis", "session_api_backup.jsonl" )
        with open(token_file) as f :
            lines = f.readlines()
            session_list = [json.loads(line) for line in lines if len(line.strip())>0  ]
            x_session_list = [x for x in session_list if "email" not in x  ]
            
            assert len(x_session_list)<=0, x_session_list
        self.session_list = session_list 
            
    def __call__(self, text ):
        text= text[:16000]
        def _update_token():
            
            
            token_info  = random.randint(0,len(self.session_list) -1 )#(self.session_list,1 ) 
            token_info = self.session_list[token_info]
            
            if "email" not in token_info :
                print (token_info, "===="*8 )
            email = token_info["email"]
            token = token_info .get("authorization", None )#["authorization"]
            print ("now choice from ", len(self.session_list),"email" )
            
            using = "req_api"
            if np.random.randint(0,2)==0:
                al=["sess-_y","sess-_x","sess-"]
                al = [x for x in al if x in token_info]
                np.random.shuffle(al)
                token = token_info[ al[0] ]
                # if "sess-_y" in token_info :
                #     if np.random.randint(0,2)==0:
                #         token = token_info["sess-_y"]
                #     else:
                #         token = token_info["sess-_x"]
                # else:
                #     token = token_info["sess-"]

                using = "req_sess"
                if pd.isna(token) :
                    token ="Bearer "+ token_info["apis"]
                    using = "req_api"

            else:
                token ="Bearer "+ token_info["apis"]
                
            return token , token_info 
        
        for i in range(self.gap_window*2 ):
            token ,token_info = _update_token()
            # print (token ,token_info , "token ,,token_info token ,token_info ")
            # if "email" not in token_info:
            #     print ("==="*8 , token_info )
                
            xemail = token_info["email"]
            flag = self.rate_limit.limit(account_id =xemail )
            mapping={
                "openai-organization":"OpenAI-Organization",
                "authorization":"Authorization",
                "authorization":"Authorization",
                "cf_clearance":"cf_clearance",
            }
            if flag :
                # token_info.pop("email")
                # token_info.pop("apis")
                # if "sess-_x" in token_info:
                #     token_info.pop("sess-_x")
                #     token_info.pop("sess-_y")
                #     token_info.pop("__Secure-next-auth.session-token")
                allow_header = ["openai-organization"]
                token_info = {mapping.get(k,k):v for k,v in token_info.items()  if not pd.isna(v)  and k in allow_header }
                break 
            token_info = None 
            time.sleep(1)

        if token_info is None :
            raise Exception("token_info is null")
            
        # token = "Bearer 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"
        self. token = token
        # print ("token", token )
        self.headers .update({
            # "TE":"trailers",
            **token_info,
            'Authorization': token,
            # "OpenAI-Organization":"org-XKCNNSp6jlcQugOjYMfasB0f",
            })
        # print (self.headers, "self.headers")
        # json_data = {"document":text, }
        # kwargs = {'data': json.dumps(json_data) }
        data = {
            'prompt': text + "».\n<|disc_score|>",
            'max_tokens': 1,
            'temperature': 1,
            'top_p': 1,
            'n': 1,
            'logprobs': 5,
            'stop': '\n',
            'stream': False,
            'model': 'model-detect-v2',
        }
        return super(Imp, self).__call__( json=data  )

    def format(self,content  ):
        # print (content)
        
            
        import json 
        
        content = content.decode() if type(content) !=str else content
        content = json.loads(content)
        
        # content = content.json()
        
        
        if "Bearer sk-" in self.token :
            self.inc["api"]+= 1 
        else:
            self.inc["sess"]+= 1 

        
        print ("....",self.inc )
        choices = content ['choices'][0]
        logprobs = choices['logprobs']['top_logprobs'][0]
        probs = {key: 100 * np.e ** value for key, value in logprobs.items()}
        
        if '"'  in probs :
            # print ("probs", probs, content  )
            key_prob = probs['"']
            if self.class_max[0] < key_prob < self.class_max[len(self.class_max) - 1]:
                val = max(i for i in self.class_max if i < key_prob)
                class_label = self.possible_classes[self.class_max.index(val)]
            elif self.class_max[0] > key_prob:
                class_label = self.possible_classes[0]
            else:
                class_label = self.possible_classes[len(self.possible_classes) - 1]
            top_prob = {'Class': class_label, 'AI-Generated Probability': key_prob}
        # if all_probs:
        #     return probs, top_prob
        # return top_prob
    
    
            return {
                "result":class_label, #"real" "fake"
                "probability":probs ,
                "raw":content,
                }

        else:
            
            return {
                "result":None, #"real" "fake"
                "probability":None ,
                "raw":content,
                }

            
