import requests
import numpy as np
import json 
#https://github.com/promptslab/openai-detector/blob/main/detector/detector.py

class OpenaiDetector:

    def ping(self):
        url = " https://api.openai.com/dashboard/billing/subscription"
        assert self.proxy is not None , self.proxy  

        response = requests.get(url, 
                                headers=self.header,              
                                proxies= self.proxy , 
                                )
        if response.status_code == 200:
            return   response.json()
        else :
            print ("status" , response.status_code  , response.content )
            
        return None 
 
    def __init__(self, token, proxy={
            "http":'http://155.69.146.170:9100',
            "https":'http://155.69.146.170:9100',
            } ):

        self.header = {
            'Accept': '*/*',
            'Accept-Language': 'en-US,en;q=0.9,hi;q=0.8',
            'Authorization': token,
            'Connection': 'keep-alive',
            'Content-Type': 'application/json',
            'Origin': 'https://platform.openai.com',
            'Referer': 'https://platform.openai.com/',
            'Sec-Fetch-Dest': 'empty',
            'Sec-Fetch-Mode': 'cors',
            'Sec-Fetch-Site': 'same-site',
            'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',
            'sec-ch-ua': '"Not_A Brand";v="99", "Google Chrome";v="109", "Chromium";v="109"',
            'sec-ch-ua-mobile': '?0',
            'sec-ch-ua-platform': '"macOS"',
        }
        self.proxy = proxy

        self.possible_classes = ['very unlikely', 'unlikely', 'unclear if it is', 'possibly', 'likely']
        self.class_max = [10, 45, 90, 98, 99]

    def detect(self, text, all_probs=False):
        data = {
            'prompt': text + "».\n<|disc_score|>",
            'max_tokens': 1,
            'temperature': 1,
            'top_p': 1,
            'n': 1,
            'logprobs': 5,
            'stop': '\n',
            'stream': False,
            'model': 'model-detect-v2',
        }
        print (data )
        assert self.proxy is not None , self.proxy  
        
        response = requests.post(
            'https://api.openai.com/v1/completions', 
            headers=self.header, json=data,
            # headers=self.header, json=data,
            proxies= self.proxy , 
            )
        if response.status_code == 200:
            choices = response.json()['choices'][0]
            logprobs = choices['logprobs']['top_logprobs'][0]
            probs = {key: 100 * np.e ** value for key, value in logprobs.items()}
            key_prob = probs['"']
            if self.class_max[0] < key_prob < self.class_max[len(self.class_max) - 1]:
                val = max(i for i in self.class_max if i < key_prob)
                class_label = self.possible_classes[self.class_max.index(val)]
            elif self.class_max[0] > key_prob:
                class_label = self.possible_classes[0]
            else:
                class_label = self.possible_classes[len(self.possible_classes) - 1]
            top_prob = {'Class': class_label, 'AI-Generated Probability': key_prob}
            if all_probs:
                return probs, top_prob
            return top_prob
        else:
            print ("response.status_code ", response.status_code  )

        print("Check prompt, Length of sentence it should be more than 1,000 characters")
        
        return None 
    
    
    
    
if __name__=="__main__":
    import numpy as np 
    import pandas as pd 
    import json 
    import os 
    
    cur_dir = os.path.dirname( __file__ )
    
    token_file = os.path.join(cur_dir, "activate_apis", "session_api.jsonl" )
    token_file = os.path.join(cur_dir, "activate_apis", "session_api_backup.jsonl" )
    with open(token_file) as f :
        lines = f.readlines()
        session_list = [json.loads(line) for line in lines ]
    
    
    
    token_info  = np.random.choice(session_list) 
    token = token_info["sess-"]
    # op = OpenaiDetector(token="Bearer sess-7M75rW9WhIcY3EZusF4WnrPydoPcCK174jTV71Lf")
    # op = OpenaiDetector(token="Bearer {}".format(token ) )
    op = OpenaiDetector(token=token)#"Bearer sess-8Anwzt9FtcpFmk8v75RUC7HY6atrLII4YrSkUZno")
    
    
    msg="""
    244 updates can be applied immediately.
173 of these updates are standard security updates.
To see these additional updates run: apt list --upgradable

New release '22.04.2 LTS' available.
Run 'do-release-upgrade' to upgrade to it.


Last login: Fri Feb 24 16:06:22 2023 from 10.91.99.125
$ 
$ exit
Connection to 155.69.146.118 closed.
root@shangqing-HP-Z640-Workstation:/home/shangqing# 
root@shangqing-HP-Z640-Workstation:/home/shangqing# 
root@shangqing-HP-Z640-Workstation:/home/shangqing# ssh xuxiufeng@155.69.146.118
xuxiufeng@155.69.146.118's password: 
Welcome to Ubuntu 20.04.4 LTS (GNU/Linux 5.4.0-122-generic x86_64)

 * Documentation:  https://help.ubuntu.com
 * Management:     https://landscape.canonical.com
 * Support:        https://ubuntu.com/advantage

  System information as of Fri 24 Feb 2023 04:12:43 PM +08

  System load:    0.95             Processes:                879
  Usage of /home: 1.7% of 1.87TB   Users logged in:          2
  Memory usage:   8%               IPv4 address for docker0: 172.17.0.1
  Swap usage:     0%               IPv4 address for eno4:    155.69.146.118
  Temperature:    39.0 C           IPv4 address for eno4:    155.69.147.68

  => There is 1 zombie process.

 * Strictly confined Kubernetes makes edge and IoT secure. Learn how MicroK8s
   just raised the bar for easy, resilient and secure K8s cluster deployment.

   https://ubuntu.com/engage/secure-kubernetes-at-the-edge

244 updates can be applied immediately.
173 of these updates are standard security updates.
To see these additional updates run: apt list --upgradable

New release '22.04.2 LTS' available.
Run 'do-release-upgrade' to upgrade to it.


Last login: Fri Feb 24 16:12:25 2023 from 155.69.145.160
xuxiufeng@server7:~$ 
xuxiufeng@server7:~$ 
xuxiufeng@server7:~$ 
xuxiufeng@server7:~$ 
"""
    info = op.detect(text=msg, all_probs=True)
    print (info )
    