import json
import logging
import re
import uuid

import time 
from time import sleep
import sys

import undetected_chromedriver as uc
from requests.exceptions import HTTPError
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait

# Disable all logging
logging.basicConfig(level=logging.ERROR)


# BASE_URL = "https://chat.openai.com/"
BASE_URL ="https://platform.openai.com/account/api-keys"

import traceback 
from threading import Thread

import chromedriver_autoinstaller


import tls_client 
driver_path = chromedriver_autoinstaller.install()


class Chrome(uc.Chrome):
    # pass
    def __del__(self):
        logging.error("chrome exist .....in del ")
        self.quit()

class Chatbot:
    def __init__(
        self,
        config,
        conversation_id=None,
        parent_id=None,
        no_refresh=False,
    ) -> None:
        self.config = config
        
        # driver = None 
        # self.accessToken = None 
        self.session_token = None 
        self.proxies = None 
        
        
        self.accessToken = None
        self.accessToken_found = False

        self.accessToken_xorg = None
        self.accessToken_found_org = False

        # self._cookie_dict ={}
        # self._header_dict ={}
        self.session = tls_client.Session(
            client_identifier="chrome_110",
        )

        if "proxy" in config:
            if type(config["proxy"]) != str:
                raise Exception("Proxy must be a string!")
            proxies = {
                "http": config["proxy"],
                "https": config["proxy"],
            }
            self.proxies = proxies 
            self.session.proxies.update(proxies)
        if "verbose" in config:
            if type(config["verbose"]) != bool:
                raise Exception("Verbose must be a boolean!")
            self.verbose = config["verbose"]
        else:
            self.verbose = False

        self.verbose = True 

        self.conversation_id = conversation_id
        self.parent_id = parent_id
        self.conversation_mapping = {}
        self.conversation_id_prev_queue = []
        self.parent_id_prev_queue = []
        self.isMicrosoftLogin = False
        # stdout colors
        self.GREEN = "\033[92m"
        self.WARNING = "\033[93m"
        self.ENDCOLOR = "\033[0m"
        


        __retry_refresh_tread=None 
        # __keep_alive_thread=None 
        
        try :
            if "email" in config and "password" in config:
                if type(config["email"]) != str:
                    raise Exception("Email must be a string!")
                if type(config["password"]) != str:
                    raise Exception("Password must be a string!")
                self.email = config["email"]
                self.password = config["password"]
                if "isMicrosoftLogin" in config and config["isMicrosoftLogin"] == True:
                    self.isMicrosoftLogin = True
                    self.__microsoft_login()
                else:
                    print ("start email login ")
                    self.__email_login()
            else:
                raise Exception("Invalid config!")



        finally:
            print ("access_token in init ", self.accessToken)
            print ("session_toek in init ", self.session_token)
            print ("cf_cookie_found in init ", self.cf_cookie_found)
            print ("puid_cookie_found in init ", self.puid_cookie_found)
            
            print ("session_cookie_found in init ", self.session_cookie_found)
            print ("agent_found in init ", self.agent_found)
            print ("cf_clearance in init ", self.cf_clearance)
            print ("puid_cookie in init ", self.puid_cookie)
            print ("user_agent in init ", self.user_agent)

            self._stop_daemon = True  #
            
            logging.error("sleeping  ")
            if self.accessToken :
                
                with open("session_api.jsonl","a") as f :
                    import json 
                    f.write(json.dumps({
                        "email":self.config["email"],
                        "sess-":self.accessToken,
                        "user-agent":self.user_agent,
                        "authorization":self.accessToken,
                        "openai-organization":self.accessToken_xorg,
                         "__Secure-next-auth.session-token":self.session_token,
                         "cf_clearance":self.cf_clearance,
                         }) )
                    f.write("\n")
            
            logging.error("sleeping  out ")
            


    def _is_capacity_try_refresh(self, driver, retry=15 ):
        try :
            for i in range(retry):
                WebDriverWait(driver, 30).until(
                    EC.element_to_be_clickable(
                        (By.XPATH, "//div[contains(text(), 'ChatGPT is at capacity right now')]"),
                    ),
                )
                logging.error("the page is in capacity. refresh time={}".format( i ))
                
                driver . refresh ()
                sleep(2)

            return True 
        except :
            logging.error("the page is normal, not int capacity")

            return False 
        
         

    def __microsoft_login(self) -> None:
        """
        Login to OpenAI via Microsoft Login Authentication.
        :return: None
        """
        driver = None 
        try:
            # Open the browser
            self.cf_cookie_found = False
            self.puid_cookie_found = False
            self.session_cookie_found = False
            self.agent_found = False
            self.cf_clearance = None
            self.puid_cookie = None
            self.user_agent = None
            options = self.__get_ChromeOptions()
            print("[ms_login]  Spawning browser...")
            driver = uc.Chrome(
                enable_cdp_events=True,
                options=options,
                driver_executable_path=self.config.get("driver_exec_path"),
                browser_executable_path=self.config.get("browser_exec_path"),
            )
            print("[ms_login] Browser spawned.")
            driver.add_cdp_listener(
                "Network.responseReceivedExtraInfo",
                lambda msg: self.__detect_cookies(msg),
            )
            driver.add_cdp_listener(
                "Network.requestWillBeSentExtraInfo",
                lambda msg: self.__detect_user_agent(msg),
            )
            driver.get(BASE_URL)
            
            # Thread(target=self.__get_myip, daemon=True).start()

            # while not self.agent_found or not self.cf_cookie_found:
            #     sleep(5)
                
            # if self._is_capacity_try_refresh(driver=driver):
            #     raise Exception("openai in capacity, try open new papge ")
            #
            # self.__refresh_headers(
            #     cf_clearance=self.cf_clearance,
            #     puid_cookie=self.puid_cookie,
            #     user_agent=self.user_agent,
            #     access_token=self.accessToken,
            # )
            # Wait for the login button to appear
            print ("start click login ")
            # Wait for the login button to appear
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//button//span[contains(text(), 'Log in')]"),
                ),
            )
            # Click the login button
            driver.find_element(
                by=By.XPATH,
                value="//button//span[contains(text(), 'Log in')]",
            ).click()

            # Wait for the Login with Microsoft button to be clickable
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//button[@data-provider='windowslive']"),
                ),
            )
            # Click the Login with Microsoft button
            driver.find_element(
                by=By.XPATH,
                value="//button[@data-provider='windowslive']",
            ).click()
            # Wait for the email input field to appear
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.XPATH, "//input[@type='email']"),
                ),
            )
            # Enter the email
            driver.find_element(
                by=By.XPATH,
                value="//input[@type='email']",
            ).send_keys(self.config["email"])
            # Wait for the Next button to be clickable
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//input[@type='submit']"),
                ),
            )
            # Click the Next button
            driver.find_element(
                by=By.XPATH,
                value="//input[@type='submit']",
            ).click()
            # Wait for the password input field to appear
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.XPATH, "//input[@type='password']"),
                ),
            )
            # Enter the password
            driver.find_element(
                by=By.XPATH,
                value="//input[@type='password']",
            ).send_keys(self.config["password"])
            # Wait for the Sign in button to be clickable
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//input[@type='submit']"),
                ),
            )
            # Click the Sign in button
            driver.find_element(
                by=By.XPATH,
                value="//input[@type='submit']",
            ).click()
            # Wait for the Allow button to appear
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//input[@type='submit']"),
                ),
            )
            # click Yes button
            driver.find_element(
                by=By.XPATH,
                value="//input[@type='submit']",
            ).click()
            # wait for input box to appear (to make sure we're signed in)
            # WebDriverWait(driver, 30).until(
            #     EC.visibility_of_element_located(
            #         (By.XPATH, "//textarea"),
            #     ),
            # )
            # while not self.session_cookie_found:
            #     sleep(5)
            print(self.GREEN + "Login successful." + self.ENDCOLOR)

            self.activate_auth_session(driver=driver )

        except Exception as ex :
            traceback.print_exc()
            raise Exception(ex)

        finally:
            # Close the browser
            if driver is not None:
                # driver = driver 
                driver.quit()
                del driver

    def __email_login(self) -> None:
        """
        Login to OpenAI via Email/Password Authentication and 2Captcha.
        :return: None
        """
        # Open the browser
        driver = None 
        try:
            self.cf_cookie_found = False
            self.puid_cookie_found = False
            self.session_cookie_found = False
            self.agent_found = False
            self.cf_clearance = None
            self.puid_cookie = None
            self.user_agent = None
            options = self.__get_ChromeOptions()
            print("[__email_login] Spawning browser...")
            driver = uc.Chrome(
                enable_cdp_events=True,
                options=options,
                driver_executable_path=self.config.get("driver_exec_path"),
                browser_executable_path=self.config.get("browser_exec_path"),
            )
            print("[__email_login] Browser spawned.")
            driver.add_cdp_listener(
                "Network.responseReceivedExtraInfo",
                lambda msg: self.__detect_cookies(msg),
            )
            driver.add_cdp_listener(
                "Network.requestWillBeSentExtraInfo",
                lambda msg: self.__detect_user_agent(msg),
            )
            driver.get(BASE_URL)


            print ("start click login ")
            # Wait for the login button to appear
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//button//span[contains(text(), 'Log in')]"),
                ),
            )
            # Click the login button
            driver.find_element(
                by=By.XPATH,
                value="//button//span[contains(text(), 'Log in')]",
            ).click()
            # Wait for the email input field to appear
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.ID, "username"),
                ),
            )
            print ("start click email  ")

            # Enter the email
            driver.find_element(by=By.ID, value="username").send_keys(
                self.config["email"],
            )
            # Wait for the Continue button to be clickable
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//button[@type='submit']"),
                ),
            )
            print ("start click email's submit  ")

            # Click the Continue button
            driver.find_element(
                by=By.XPATH,
                value="//button[@type='submit']",
            ).click()

            print ("start passwork  ")

            # Wait for the password input field to appear
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.ID, "password"),
                ),
            )
            # Enter the password
            driver.find_element(by=By.ID, value="password").send_keys(
                self.config["password"],
            )
            print ("start passwork submit  ")

            # Wait for the Sign in button to be clickable
            WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//button[@type='submit']"),
                ),
            )
            # Click the Sign in button
            driver.find_element(
                by=By.XPATH,
                value="//button[@type='submit']",
            ).click()
            
        
            print(self.GREEN + "Login successful." + self.ENDCOLOR)

            self.activate_auth_session(driver=driver )

        except Exception as ex :
            
            traceback.print_exc()
            raise Exception(ex)
        finally:
            if driver is not None:
                # Close the browser
                # driver = driver 
                driver.quit()
                del driver

    def __get_ChromeOptions(self):
        options = uc.ChromeOptions()
        options.add_argument("--start_maximized")
        options.add_argument("--disable-extensions")
        options.add_argument("--disable-application-cache")
        options.add_argument("--disable-gpu")
        options.add_argument("--no-sandbox")
        options.add_argument("--disable-setuid-sandbox")
        options.add_argument("--disable-dev-shm-usage")
        print ("------->"* 8 ,"self proxy ", self.config )
        if self.config.get("proxy", "") != "":
            options.add_argument("--proxy-server=" + self.config["proxy"])
            
        return options

    def __get_cf_cookies(self) -> None:
        """
        Get cloudflare cookies.
        :return: None
        """
        driver = None 
        try:
            self.cf_cookie_found = False
            self.agent_found = False
            self.puid_cookie_found = False
            self.cf_clearance = None
            self.puid_cookie = None
            self.user_agent = None
            options = self.__get_ChromeOptions()
            print("[__get_cf_cookies] Spawning browser...")
            driver = uc.Chrome(
                enable_cdp_events=True,
                options=options,
                driver_executable_path=self.config.get("driver_exec_path"),
                browser_executable_path=self.config.get("browser_exec_path"),
            )
            print("[__get_cf_cookies] Browser spawned.")
            driver.add_cdp_listener(
                "Network.responseReceivedExtraInfo",
                lambda msg: self.__detect_cookies(msg),
            )
            driver.add_cdp_listener(
                "Network.requestWillBeSentExtraInfo",
                lambda msg: self.__detect_user_agent(msg),
            )
            driver.get("https://chat.openai.com/chat")
            while (
                not self.agent_found
                or not self.cf_cookie_found
                or not self.puid_cookie_found
            ):
                print ("sleep.in __get_cf_cookies")
                sleep(5)
        except :
            traceback.print_exc()
        finally:
            # Close the browser
            if driver is not None:
                # driver  = driver 
                driver.quit()
                del driver
            self.__refresh_headers(
                cf_clearance=self.cf_clearance,
                puid_cookie=self.puid_cookie,
                user_agent=self.user_agent,
                access_token=self.accessToken,

            )
        # return driver 

    def __detect_cookies(self, message):
        if "params" in message:
            if "headers" in message["params"]:
                if "set-cookie" in message["params"]["headers"]:
                    # Use regex to get the cookie for cf_clearance=*;
                    cf_clearance_cookie = re.search(
                        "cf_clearance=.*?;",
                        message["params"]["headers"]["set-cookie"],
                    )
                    puid_cookie = re.search(
                        "_puid=.*?;",
                        message["params"]["headers"]["set-cookie"],
                    )
                    session_cookie = re.search(
                        "__Secure-next-auth.session-token=.*?;",
                        message["params"]["headers"]["set-cookie"],
                    )
                    if cf_clearance_cookie and not self.cf_cookie_found:
                        print("Found Cloudflare Cookie!")
                        # remove the semicolon and 'cf_clearance=' from the string
                        raw_cf_cookie = cf_clearance_cookie.group(0)
                        self.cf_clearance = raw_cf_cookie.split("=")[1][:-1]
                        if self.verbose:
                            print(
                                self.GREEN
                                + "Cloudflare Cookie: "
                                + self.ENDCOLOR
                                + self.cf_clearance,
                            )
                        self.cf_cookie_found = True
                    if puid_cookie and not self.puid_cookie_found:
                        print("Found puid_cookie Token!")

                        raw_puid_cookie = puid_cookie.group(0)
                        self.puid_cookie = raw_puid_cookie.split("=")[1][:-1]
                        self.session.cookies.set(
                            "_puid",
                            self.puid_cookie,
                        )
                        if self.verbose:
                            print(
                                self.GREEN
                                + "puid Cookie: "
                                + self.ENDCOLOR
                                + self.puid_cookie,
                            )
                        self.puid_cookie_found = True
                    if session_cookie and not self.session_cookie_found:
                        print("Found Session Token!")
                        # remove the semicolon and '__Secure-next-auth.session-token=' from the string
                        raw_session_cookie = session_cookie.group(0)
                        self.session_token = raw_session_cookie.split("=")[1][:-1]
                        self.session.cookies.set(
                            "__Secure-next-auth.session-token",
                            self.session_token,
                        )
                        if self.verbose:
                            print(
                                self.GREEN
                                + "Session Token: "
                                + self.ENDCOLOR
                                + self.session_token,
                            )
                        self.session_cookie_found = True

    def __detect_user_agent(self, message):
        self.__detect_auth_header(message=message) 
        
        if "params" in message:
            if "headers" in message["params"]:
                if "user-agent" in message["params"]["headers"]:
                    # Use regex to get the cookie for cf_clearance=*;
                    user_agent = message["params"]["headers"]["user-agent"]
                    self.user_agent = user_agent
                    self.agent_found = True
                
        self.__refresh_headers(
            cf_clearance=self.cf_clearance,
            puid_cookie=self.puid_cookie,
            user_agent=self.user_agent,
            access_token=self.accessToken,
        )

    def __detect_auth_header(self, message):
        if "params" in message:
            if "headers" in message["params"]:
                if "authorization"  in message["params"]["headers"]:
                    authorization = message["params"]["headers"]["authorization"]
                    if "Bearer sess-" in authorization:
                        print ("authorization"  , authorization )
                        self.accessToken = authorization
                        self.accessToken_found = True
                if "openai-organization"  in message["params"]["headers"]:
                    xorg = message["params"]["headers"]["openai-organization"]
                    if "org-" in xorg:
                        print ("openai-organization"  , xorg )
                        self.accessToken_xorg = xorg
                        self.accessToken_found_org = True

        self.__refresh_headers(
            cf_clearance=self.cf_clearance,
            puid_cookie=self.puid_cookie,
            user_agent=self.user_agent,
            access_token=self.accessToken,
        )

    def __refresh_headers(self,**kwargs):
        pass 

    def activate_auth_session(self, driver ):
        print ("start billing  ")
        ## billing 
        # with open("tmp_billing.html","w") as f :
        #     f.write( driver.page_source) 
            
        try :
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.XPATH, "//div[@class='user-details']"),
                ),
            )
            driver.find_element(
                by=By.XPATH,
                value= "//div[@class='user-details']",
            ).click()
            print ("sucess", "001" )

        except :
            pass 

        billing_url ="https://platform.openai.com/account/billing/history"
        
        driver.get(billing_url)
        

        api_key= None 
        
        try :            
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.XPATH,  "//div[contains(@class,'billing-page')]//p[@class='billing-subtext']"),
                ),
            )
            driver.find_element(
                by=By.XPATH,
                value= "//div[contains(@class,'billing-page')]//p[@class='billing-subtext']",
            ).click()

            print ("sucess", "002" )
        except :
            traceback.print_exc() 
            pass 
        # with open("tmp_billing_history.html","w") as f :
        #     f.write( driver.page_source) 
            

        billing_url ="https://platform.openai.com/account/members"
        driver.get(billing_url)
        

        try :            
            WebDriverWait(driver, 30).until(
                EC.visibility_of_element_located(
                    (By.XPATH, "//div[@class='acct-body']//div[@class='org-member-email']"),
                ),
            )
            driver.find_element(
                by=By.XPATH,
                value="//div[@class='acct-body']//div[@class='org-member-email']",
            ).click()

            print ("success", "003" )
        except :
            traceback.print_exc() 
            pass 
        
        print ("start billing history ")
        ## billing 
        sleep(5)
        
        
        
if __name__=="__main__":
    # dsa=
    import os 
    import numpy as np 
    import pandas as pd 
    with open("sucess.list.jsonl") as f :
        data= [json.loads(x) for x in f.readlines()]
        df = pd.DataFrame(data)
        df["isMicrosoftLogin"]=False



    #df = pd.read_csv("./access_token_openai.csv").rename(columns={"is_ms":"isMicrosoftLogin"})
    #df = df.drop_duplicates(subset="email")

    # df = df[ df["isMicrosoftLogin"]==1 ]
    exist_user = []
    if os.path.isfile("session_api.jsonl") :
        with open("session_api.jsonl") as f :
            exist_user = [json.loads(line) for line in f.readlines() ]
            exist_user = [ info["email"]  for info  in exist_user ]
    
    print ("before filter", len(df))
    df = df [~ df["email"].isin( exist_user) ]
    print ("after filter", len(df))
    
    df_list = df.to_dict(orient="records")
    #print ( len(df_list) , "df_list") 
    #exit()
    config = np.random.choice(df_list)
    
    print ("driver_path", driver_path )
    
    
    import platform
    import chromedriver_autoinstaller
    driver_path = chromedriver_autoinstaller.install()  # Check if the current version of chromedriver exists

    obj =  Chatbot(
        config={
            "proxy":"http://155.69.145.160:9100",
            "driver_exec_path" :driver_path,# "/Users/aa/Downloads/chromedriver_mac64_109/chromedriver" , 
            "browser_exec_path": "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome" if platform.system()!="Linux" else "/opt/google/chrome/chrome",
#"/Applications/Google Chrome.app/Contents/MacOS/Google Chrome",
            **config 
            },
    ) 
    
      
        
    base_url ="https://platform.openai.com/account/api-keys"
    
    #https://platform.openai.com/account/api-keys
    
    
    "//div[class=api-keys]//button"
    
