import tls_client
import os 
import json 
import time 
     
class RegisterAPI :
    def __init__(self, config, access_token, email  ):
        self.session = tls_client.Session(
            client_identifier="chrome_110",
        )
        if "proxy" in config:
            if type(config["proxy"]) != str:
                raise Exception("Proxy must be a string!")
            proxies = {
                "http": config["proxy"],
                "https": config["proxy"],
            }
            self.proxies = proxies 
            self.session.proxies.update(proxies)

        self.config_user= {
            "email":email,
            "sess-":access_token,
            }
        
        print (self.config_user, "config_user " )
        user_agent= "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36"
        self.session.headers.update(
            {
                "Accept": "text/event-stream",
                # "Authorization": "Bearer ",
                # "Authorization": f"Bearer {access_token}",
                "Authorization": access_token,
                "Content-Type": "application/json",
                "User-Agent": user_agent,
                "X-Openai-Assistant-App-Id": "",
                "Connection": "close",
                "Accept-Language": "en-US,en;q=0.9",
                "Referer": "https://chat.openai.com/chat",
            },
        )
        
        print ("get all api")
        self.get_all_api()
        print ("create one api")
        self.create_api_keys()
        print ("get  all api")
        self.get_all_api()
        
    def get_all_api(self):
        url ="https://api.openai.com/dashboard/user/api_keys"
        response = self.session.get(url)
        if response.status_code ==200:
            ret_info = response.json() 
            return ret_info
        else:
            print (response.content,"failt") 

        
        
    def create_api_keys(self):
        
        url = "https://api.openai.com/dashboard/user/api_keys"
        data = {"action":"create"}
        response = self.session.post(url,json=data )
        try :
            print (response.json() )
        except :
            print (response.status_code,"status_code" )
            
        if response.status_code ==200:
            ret_info = response.json()
            print ("success", ret_info  )
            self.config_user["apis"]= ret_info["key"]["sensitive_id"]
            self.config_user["raw"]= ret_info
            with open("convert_api.jsonl","a") as f :
                f.write(json.dumps(self.config_user))
                f.write("\n")
            return  ret_info 
        return None 

    
with open("convert_api.jsonl") as f :
    exist_data_list= [json.loads(x.strip()) for x in f.readlines()]
    exist_data_list = [item["email"] for item in exist_data_list ]

with open("session_api.jsonl") as f :
    data_list= [json.loads(x.strip()) for x in f.readlines()]
    data_list = [item for item in data_list if item["email"] not in exist_data_list]
    
    
for item in data_list:
    access_token = item["sess-"]
    email = item["email"]
    obj =  RegisterAPI(
        config={
            "proxy":"http://155.69.145.160:9100",
            },
        access_token=access_token,
        email=email,
    ) 


    time.sleep(3)