
import json 
from ..base  import BaseRequest
from ..utils import api_call 

import pandas as pd 
import numpy as np 

import random 
import os 
cur = os.path.dirname(__file__)
class Imp(BaseRequest):
    
    def __init__(self, ): 
        
        url = "https://api.gptzero.me/v2/predict/text"
        super(Imp, self).__init__(url=url )
        # self.
        
        
        self.headers .update({
            'content-type': 'application/json' ,

            # 'content-type':'application/x-www-form-urlencoded; charset=UTF-8',
            'Origin': 'https://app.gptzero.me',
            'Referer': 'https://app.gptzero.me',
            # 'X-Requested-With': 'XMLHttpRequest',
            "Authority": "api.gptzero.me",
            })

        self.method = "POST"
        

    def __call__(self, text ):
        # print ("text", text )
        text = text[:20000-500]
        text = text.replace("`","'")
        text = text.replace("'",'"')
        json_data = {"document":text, "source":"landing", "writing_stats_required":False, "sampleTextSubmitted":False, "interpretability_required":False , "checkPlagiarism":False }

        return super(Imp, self).__call__( data=json.dumps(json_data) )



    def format(self,content  ):
        # print (content)
        # if content is None :
        #     return content
        
        '''
{
    "documents": [
        {
            "average_generated_prob": 1,
            "completely_generated_prob": 0.9752832361642448,
            "overall_burstiness": 13.855096817016602,
            "paragraphs": [
                {
                    "completely_generated_prob": 0.9752832361642448,
                    "num_sentences": 32,
                    "start_sentence_index": 0
                }
            ],
            "sentences": [
                {
                    "generated_prob": 1,
                    "perplexity": 12,
                    "sentence": "When I first heard about what a lot of people are calling the 'anti-transgender' law passed in Arkansas last week, it came as a complete surprise to me."
                },
                {
                    "generated_prob": 1,
                    "perplexity": 73,
                    "sentence": "I was one of the supporters behind Prop 8 .\\nAnd so I am quite surprised to hear of this new law passed in Kentucky."
                },
                {
                    "generated_prob": 1,
                    "perplexity": 30,
                    "sentence": "I don't know your situation, but if you are looking for an extreme level of religious liberty, you could probably take a closer look at this 'religious freedom' bill here:\\u00a0\\nAnd here's a more personal experience with this \\\"religious freedom\\\" bill:\\nAs a college student, I was forced to write a paper on how gay and transgender people were destroying gay marriage and why."
                }
            ]
        }
    ]
}

        '''
        import json 
        content = content if type(content)==str else content.decode()
        # print (content , "b.content " )
        info_raw = json.loads(content )
        info = info_raw ["documents"][0]
        
        # classification==1 --> human 
        # classification==2  --> ai 
        
        result =1 if  info["average_generated_prob"]>0.8 else 0
        probability = info ["average_generated_prob"]
        return {
            "result":result, #"real" "fake"
            "probability":probability ,
            "raw_response":info_raw,
            }
