
import json 
from ..base  import BaseRequest


import nltk
import string



class Imp(BaseRequest):
    
    def __init__(self, ): 
        
        url = "https://detectgpt.ericmitchell.ai/get_result"
        super(Imp, self).__init__(url=url )
        # self.
        
        self.headers .update({
            'content-type':'application/x-www-form-urlencoded; charset=UTF-8',
            'Origin': 'https://detectgpt.ericmitchell.ai',
            'Referer': 'https://detectgpt.ericmitchell.ain/',
            'X-Requested-With': 'XMLHttpRequest',
            "Authority": "detectgpt.ericmitchell.ai",
            })

        self.method = "POST"
        
    def __call__(self, text ):
        text_list = nltk.word_tokenize(text)
        text_list = text_list[:250]
        text = "".join([" "+i if not i.startswith("'") and i not in string.punctuation else i for i in text_list]).strip()
        ## the website mondatory ask under 256 token 
        json_data = {"text":text, }
        # kwargs = {'data': json.dumps(json_data) }

        return super(Imp, self).__call__( data=json_data )

    def format(self,content  ):
        print (content)
        
        '''
{
  "results": [
    {
      "classification": 2,
      "probability": 0.99982315,
      "matches": [
        {
          "text": {
            "chars": {
              "starts": [
                0
              ],
              "lengths": [
                649
              ]
            },
            "words": {
              "starts": [
                0
              ],
              "lengths": [
                150
              ]
            }
          }
        }
      ]
    }
  ],
  "summary": {
    "human": 0,
    "ai": 1
  },
  "scannedDocument": {
    "scanId": "8bd52333-7e81-43b3-806f-bbb1a3041693",
    "creationTime": "2023-02-25T17:15:31.187863Z"
  }
}        

        '''
        import json 
        content = content if type(content)==str else content.decode()
        # print (content , "b.content " )
        info = json.loads(content )
        if "status" in info and info ["status"]=="OK":
        
            # classification==1 --> human 
            # classification==2  --> ai 
            
            result =1 if  info["classification"]==2 else 0
            probability = info ["probability"]
            return {
                "result":result, #"real" "fake"
                "probability":probability ,
                "raw_result":info,
                }
