
from .utils.q_utils import sync
from .utils.q_utils import MsgBody, Headers,BasicMessageReceiver,BasicMessageSender


import crawler_servicing
import traceback 
import time 

class MyConsumer(BasicMessageReceiver):
    def __init__(self, case_name ="test" ):
        super().__init__()
        self._result_producer = None
        self.case_name = case_name
        
        # self.q_name_in = case_name+"_in"
        self.q_name_in = case_name
        self.q_name_out  = case_name+"_out"
        
        self.service = None 

    
    @sync
    async def consume(self, channel, method, properties, body):
        # print ( type(method), "typoe.method") 
        # print (properties, "properties", dir(properties) )
        #
        try :

            body = self.decode_message(body=body)
            
            # print("???", type(body) , "body...", list(body), body )
            content = body["content"]
            if type(content)==list:
                content =content[0]
            # print (body["mapping_key"])
            
            file_content = await self._download_image(content=content)#img_url=body["url"] if "url" in body else body["msg"] )

            # consume message logic ...
            def send_out(result ,task_type="step2:result_in"):
                exchange_name="exc_"+self.case_name
                routing_key=self.q_name_out
                msg= MsgBody(
                    **body,
                    result=result,
                    )
        
                header_in  = properties.headers
                if "task_type" in header_in :
                    del header_in["task_type"]
                headers = Headers(**header_in,
                    task_type=task_type,
                    )
                self._result_producer.check_connection()
                # print ("send out ", routing_key )
                self._result_producer.send_message(
                    exchange_name=exchange_name,
                    routing_key=routing_key,
                    body=msg.__dict__,
                    headers=headers,
                    )
                
            send_out(file_content)
    
            self.ack_done(tag=method.delivery_tag )
        except :
            traceback.print_exc()
            self.check_connection()
            self.ack_fale(tag=method.delivery_tag )
            time.sleep(1)
        finally:
            time.sleep(0.4)

        
    async def _download_image(self, content):
        # import random 
        #
        # rid = random.randint(0,10)
        # time.sleep(rid)
        #
        # print (content)
        # if rid!=9 :
        #     raise Exception("faile" )
        if len(content.strip())==0:
            return None

        result = self.service (content )
        
        return result 
    

    

    def instance(self):
        import importlib 
        if self.case_name in ["DetectGPT","GPT2_Detector","GPTZero","Hello_SimpleAI_qa","Hello-SimpleAI-qa","Hello_SimpleAI","Hello-SimpleAI","gptzerosg_fn0","gptzerosg_fn1", "mt_func1",  "mt_func2", "mt_func3", 
                              "mt_func4", "mt_func5",
                              
                              "ArguGPT", "ICLR2024_AIGC_text_detector",
                              "RADAR_nips2023", "yaful",
                               
                               ]:
            service  = importlib.import_module('crawler_servicing.opensource.'+self.case_name.replace("-","_"))
        else:
            service  = importlib.import_module('crawler_servicing.'+self.case_name+'.imp',)
        # service = getattr(crawler_servicing,self.case_name) 
        self.service = service.Imp()
        
        
        
        if self._result_producer is None :
            #or self._result_producer.check_connection():
            self._result_producer= BasicMessageSender()
            
            self._result_producer.declare_queue(queue_name=self.q_name_out )
            self._result_producer.declare_exchange(exchange_name="exc_"+self.case_name)
            self._result_producer.bind_queue(
                exchange_name="exc_"+self.case_name, queue_name=self.q_name_out , routing_key=self.q_name_out,
            )
                #"step2:result_in"
    
        self.declare_queue(queue_name=self.q_name_in)
        self.declare_exchange(exchange_name="exc_"+self.case_name)
        self.bind_queue(
            exchange_name="exc_"+self.case_name, queue_name=self.q_name_in, routing_key="step1:data_out"
        )






def create_consumer(case_name = "test"):
    # print (case_name,"c")
    try :
        worker = MyConsumer(case_name=case_name)
        worker.instance()
        worker.consume_messages(queue=worker.q_name_in, callback=worker.consume)
    except KeyboardInterrupt:
        worker.cancel_consumer()
    except :
        traceback.print_exc()



if __name__ == "__main__":

    
    create_consumer()
    
    
    
    
    
