import requests
import time
import os 

# Define the retrying parameters
MAX_ATTEMPTS = 3
WAIT_INITIAL_SEC = 2
WAIT_MULTIPLIER = 2



# 155.69.147.193
# http://155.69.146.170/
# http://155.69.145.160/
class BaseRequest:
    def __init__(self,
                 url ,
            headers ={},   
            proxies={
                "http":os.environ.get("proxy",'http://10.96.187.173:9100/'),
                "https":os.environ.get("proxy",'http://10.96.187.173:9100/'),
                # "http":'http://47.87.143.109:9100',
                # "https":'http://47.87.143.109:9100',
                },
            timeout = int ( os.environ.get("TIMEOUT", 60*2)),  
            method= "GET",
            return_rsp = False, 
        ):
        assert method in ["GET","POST"], method
        
        self.return_rsp = return_rsp 
        
        self. url = url 
        # Define the URL to request
        # self.URL_TO_REQUEST = URL_TO_REQUEST 
        #= 'https://example.com'
        self.headers = {
            'Accept': '*/*',
            'Accept-Language': 'en-US,en;q=0.9,hi;q=0.8',
            # 'Authorization': token,
            # 'Connection': 'keep-alive',
            'Content-Type': 'application/json',
            # 'Origin': 'https://platform.openai.com',
            # 'Referer': 'https://platform.openai.com/',
            # 'Sec-Fetch-Dest': 'empty',
            # 'Sec-Fetch-Mode': 'cors',
            # 'Sec-Fetch-Site': 'same-site',
            'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36',
            # 'sec-ch-ua': '"Not_A Brand";v="99", "Google Chrome";v="109", "Chromium";v="109"',
            # 'sec-ch-ua-mobile': '?0',
            # 'sec-ch-ua-platform': '"macOS"',
        }

        self .headers.update(headers) 
        self. proxies = proxies  
        self.timeout  = timeout 
        self.method = method 
        
    def format(self,content ):
        raise Exception("un imp")
        return {
            "result":1, #"real" "fake"
            "probability": 0 ,
            }
        
    def __call__(self, **kwargs):

        content = self.__call_imp__(**kwargs )
        return self.format(content =content )
    
    
    def __call_imp__(self, **kwargs):

        # Define the callback function
        def request_content(return_rsp=False):
            attempts = 0
            while attempts < MAX_ATTEMPTS:
                try:
                    method = requests.get if self.method=="GET" else requests.post 
                    # print ( self.url , self.proxies, self.headers, self.timeout  )
                    response = method(self.url ,
                                            proxies=self.proxies,
                                            headers= self. headers, 
                                            timeout =self.timeout, 
                                            **kwargs )
                    # print ("response", response.status_code)
                    # if response.status_code==429:
                    #     print (response.headers,self. headers)
                    # if response.status_code==400:
                    #     print (kwargs, "--->", response.content  )
                    # print ("response",  type(response), dir(response ))
                    #print ("response",  response.content )
                    
                    response.raise_for_status()
                    if return_rsp:
                        return response 
                    
                    return response.content
                except requests.exceptions.RequestException as e:
                    print(f'Request failed with error: {str(e)}')
                    attempts += 1
                    if attempts < MAX_ATTEMPTS:
                        wait_time = WAIT_INITIAL_SEC * (WAIT_MULTIPLIER ** attempts)
                        print(f'Retrying in {wait_time} seconds...')
                        time.sleep(wait_time)
            raise requests.exceptions.RequestException('Request failed after multiple attempts')

        # Call the callback function
        try:
            
            content = request_content(return_rsp=self.return_rsp )
            # print(f'Response content: {content}')
            return content 
        except requests.exceptions.RequestException as e:
            pass 
            # print(str(e))
        return None 

