
import json 
from ..base  import BaseRequest


class Imp(BaseRequest):
    
    def __init__(self, ): 
        
        url = "https://ai-detector.compilatio.net/api/predict"
        super(Imp, self).__init__(url=url )
        # self.
        
        self.headers .update({
            'Origin': 'https://ai-detector.compilatio.net',
            'Referer': 'https://ai-detector.compilatio.net/',
            })

        self.method = "POST"
        
    def __call__(self, text ):
        text = text[:2000]
        json_data = {"input-text":text}
        # kwargs = {'data': json.dumps(json_data) }

        return super(Imp, self).__call__( data=json.dumps(json_data)  )

    def format(self,content  ):
        '''
    object        {1}
    result        {7}
        _id    :    63fa07f6d3d056e4ef8e8f1f
        date    :    Sat, 25 Feb 2023 13:07:02 GMT
        label    :    Human
        mainlanguage    :    en
        score    :    99.98
        text    :    this is text 
        user_md5    :    41c9fadf3cf2e28d506436eb277e227d
        
        '''
        import json 
        content = content if type(content)==str else content.decode()
        info = json.loads(content )
        info = info ["result"]
        
        result =0 if  info["label"]=="Human" else 1 
        probability = info ["score"]
        final_info = {
            "result":result, #"real" "fake"
            "probability":probability ,
            "raw_result":info , 
            }
        
        # print (final_info,"---->","\n\n\n")
        return final_info 
    