from crawler_servicing  import consume as work_consume_lib

import multiprocessing as mp
import pika
import time
import traceback

def consume(case_name):
    try :
        worker = work_consume_lib. MyConsumer(case_name=case_name)
        worker.instance()
        worker.consume_messages(queue=worker.q_name_in, callback=worker.consume)
    except KeyboardInterrupt:
        worker.cancel_consumer()
    except :
        traceback.print_exc()



if __name__ == '__main__':
    import sys 
    queue_name = sys.argv [1]
    
    num_processes = 8 #mp.cpu_count()-1
    pool = mp.Pool(num_processes)

    try:
        for i in range(num_processes):
            pool.apply_async(consume, args=(queue_name,))
        pool.close()
        pool.join()


    except KeyboardInterrupt:
        pool.terminate()
        pool.join()
    except :
        traceback.print_exc()







